// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.networth;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Shareholder's Equity
 * @author nilcy
 */
@Embeddable
public class ShareholdersEquity implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 5448673927401166952L;
    /** Legal capital */
    private Long legalCapital;
    /** Stock request deposit*/
    private Long stockRequestDeposit;
    /** Capital surplus*/
    private Long capitalSurplus;
    /** Profit Surplus*/
    private Long profitSurplus;
    /** Treasury stock*/
    private Long treasuryStock;
    /** Treasury stock request deposit*/
    private Long treasuryStockRequestDeposit;
    /**
     * getter for Legal capital
     * @return Legal capital
     */
    @Column(name = "legal_capital", nullable = true, insertable = true, updatable = true)
    public Long getLegalCapital() {
        return this.legalCapital;
    }
    /**
     * setter for Legal capital
     * @param aLegalCapital Legal capital
     */
    public void setLegalCapital(Long aLegalCapital) {
        this.legalCapital = aLegalCapital;
    }
    /**
     * getter for Stock request deposit
     * @return Stock request deposit
     */
    @Column(name = "stock_request_deposit", nullable = true, insertable = true, updatable = true)
    public Long getStockRequestDeposit() {
        return this.stockRequestDeposit;
    }
    /**
     * setter for Stock request deposit
     * @param aStockRequestDeposit Stock request deposit
     */
    public void setStockRequestDeposit(Long aStockRequestDeposit) {
        this.stockRequestDeposit = aStockRequestDeposit;
    }
    /**
     * getter for Capital surplus
     * @return Capital surplus
     */
    @Column(name = "capital_surplus", nullable = true, insertable = true, updatable = true)
    public Long getCapitalSurplus() {
        return this.capitalSurplus;
    }
    /**
     * setter for Capital surplus
     * @param aCapitalSurplus Capital surplus
     */
    public void setCapitalSurplus(Long aCapitalSurplus) {
        this.capitalSurplus = aCapitalSurplus;
    }
    /**
     * getter for Profit Surplus
     * @return Profit Surplus
     */
    @Column(name = "profit_surplus", nullable = true, insertable = true, updatable = true)
    public Long getProfitSurplus() {
        return this.profitSurplus;
    }
    /**
     * setter for Profit Surplus
     * @param aProfitSurplus Profit Surplus
     */
    public void setProfitSurplus(Long aProfitSurplus) {
        this.profitSurplus = aProfitSurplus;
    }
    /**
     * getter for Treasury stock
     * @return Treasury stock
     */
    @Column(name = "treasury_stock", nullable = true, insertable = true, updatable = true)
    public Long getTreasuryStock() {
        return this.treasuryStock;
    }
    /**
     * setter for Treasury stock
     * @param aTreasuryStock Treasury stock
     */
    public void setTreasuryStock(Long aTreasuryStock) {
        this.treasuryStock = aTreasuryStock;
    }
    /**
     * getter for Treasury stock request deposit
     * @return Treasury stock request deposit
     */
    @Column(name = "treasury_stock_request_deposit", nullable = true, insertable = true, updatable = true)
    public Long getTreasuryStockRequestDeposit() {
        return this.treasuryStockRequestDeposit;
    }
    /**
     * setter for Treasury stock request deposit
     * @param aTreasuryStockRequestDeposit Treasury stock request deposit
     */
    public void setTreasuryStockRequestDeposit(Long aTreasuryStockRequestDeposit) {
        this.treasuryStockRequestDeposit = aTreasuryStockRequestDeposit;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.legalCapital) + nvl(this.stockRequestDeposit) + nvl(this.capitalSurplus)
                + nvl(this.profitSurplus) + nvl(this.treasuryStock) + nvl(this.treasuryStockRequestDeposit);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
