// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.networth;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Assessment Convert Difference
 * @author nilcy
 */
@Embeddable
public class AssessmentConvertDifference implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 3458997271065452969L;
    /** Securities assessment difference */
    private Long securitiesAssessmentDifference;
    /** Deferred gains or losses on hedges */
    private Long deferredGainsOrLossesOnHedges;
    /** Land reassessment difference */
    private Long landReassessmentDifference;
    /** Foreign currency translation adjustment */
    private Long foreignCurrencyTranslationAdjustment;
    /** Deferred income tax liabilities */
    private Long deferredIncomeTaxLiabilities;
    /** Liabilities revised difference */
    private Long liabilitiesRevisedDifference;
    /**
     * getter for Securities assessment difference
     * @return Securities assessment difference
     */
    @Column(name = "securities_assessment_difference", nullable = true, insertable = true, updatable = true)
    public Long getSecuritiesAssessmentDifference() {
        return this.securitiesAssessmentDifference;
    }
    /**
     * setter for Securities assessment difference
     * @param aSecuritiesAssessmentDifference Securities assessment difference
     */
    public void setSecuritiesAssessmentDifference(Long aSecuritiesAssessmentDifference) {
        this.securitiesAssessmentDifference = aSecuritiesAssessmentDifference;
    }
    /**
     * getter for Deferred gains or losses on hedges
     * @return Deferred gains or losses on hedges
     */
    @Column(name = "deferred_gains_or_losses_on_hedges", nullable = true, insertable = true, updatable = true)
    public Long getDeferredGainsOrLossesOnHedges() {
        return this.deferredGainsOrLossesOnHedges;
    }
    /**
     * setter for Deferred gains or losses on hedges
     * @param aDeferredGainsOrLossesOnHedges Deferred gains or losses on hedges
     */
    public void setDeferredGainsOrLossesOnHedges(Long aDeferredGainsOrLossesOnHedges) {
        this.deferredGainsOrLossesOnHedges = aDeferredGainsOrLossesOnHedges;
    }
    /**
     * getter for Land reassessment difference
     * @return Land reassessment difference
     */
    @Column(name = "land_reassessment_difference", nullable = true, insertable = true, updatable = true)
    public Long getLandReassessmentDifference() {
        return this.landReassessmentDifference;
    }
    /**
     * setter for Land reassessment difference
     * @param aLandReassessmentDifference Land reassessment difference
     */
    public void setLandReassessmentDifference(Long aLandReassessmentDifference) {
        this.landReassessmentDifference = aLandReassessmentDifference;
    }
    /**
     * getter for Foreign currency translation adjustment
     * @return Foreign currency translation adjustment
     */
    @Column(name = "foreign_currency_translation_adjustment", nullable = true, insertable = true, updatable = true)
    public Long getForeignCurrencyTranslationAdjustment() {
        return this.foreignCurrencyTranslationAdjustment;
    }
    /**
     * setter for Foreign currency translation adjustment
     * @param aForeignCurrencyTranslationAdjustment Foreign currency translation adjustment
     */
    public void setForeignCurrencyTranslationAdjustment(Long aForeignCurrencyTranslationAdjustment) {
        this.foreignCurrencyTranslationAdjustment = aForeignCurrencyTranslationAdjustment;
    }
    /**
     * getter for Deferred income tax liabilities
     * @return Deferred income tax liabilities
     */
    @Column(name = "deferred_income_tax_liabilities", nullable = true, insertable = true, updatable = true)
    public Long getDeferredIncomeTaxLiabilities() {
        return this.deferredIncomeTaxLiabilities;
    }
    /**
     * setter for Deferred income tax liabilities
     * @param aDeferredIncomeTaxLiabilities Deferred income tax liabilities
     */
    public void setDeferredIncomeTaxLiabilities(Long aDeferredIncomeTaxLiabilities) {
        this.deferredIncomeTaxLiabilities = aDeferredIncomeTaxLiabilities;
    }
    /**
     * getter for Liabilities revised difference
     * @return Liabilities revised difference
     */
    @Column(name = "liabilities_revised_difference", nullable = true, insertable = true, updatable = true)
    public Long getLiabilitiesRevisedDifference() {
        return this.liabilitiesRevisedDifference;
    }
    /**
     * setter for Liabilities revised difference
     * @param aLiabilitiesRevisedDifference Liabilities revised difference
     */
    public void setLiabilitiesRevisedDifference(Long aLiabilitiesRevisedDifference) {
        this.liabilitiesRevisedDifference = aLiabilitiesRevisedDifference;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.securitiesAssessmentDifference) + nvl(this.deferredGainsOrLossesOnHedges) + nvl(this.landReassessmentDifference)
                + nvl(this.foreignCurrencyTranslationAdjustment) + nvl(this.deferredIncomeTaxLiabilities) + nvl(this.liabilitiesRevisedDifference);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
