// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.liability;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Long-term Liability
 * @author nilcy
 */
@Embeddable
public class LongTermLiability implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 4232930187175156793L;
    /** Bonds payable */
    private Long bondsPayable;
    /** Long-term debt */
    private Long longTermDebt;
    /** Allowance for employee retirement */
    private Long allowanceForEmployeeRetirement;
    /** Allowance for director retirement benefits */
    private Long allowanceForDirectorRetirementBenefits;
    /** Special Repair Reserve */
    private Long specialRepairReserve;
    /**
     * getter for Bonds payable
     * @return Bonds payable
     */
    @Column(name = "bonds_payable", nullable = true, insertable = true, updatable = true)
    public Long getBondsPayable() {
        return this.bondsPayable;
    }
    /**
     * setter for Bonds payable
     * @param aBondsPayable Bonds payable
     */
    public void setBondsPayable(Long aBondsPayable) {
        this.bondsPayable = aBondsPayable;
    }
    /**
     * getter for Long-term debt
     * @return Long-term debt
     */
    @Column(name = "long_term_debt", nullable = true, insertable = true, updatable = true)
    public Long getLongTermDebt() {
        return this.longTermDebt;
    }
    /**
     * setter for Long-term debt
     * @param aLongTermDebt Long-term debt
     */
    public void setLongTermDebt(Long aLongTermDebt) {
        this.longTermDebt = aLongTermDebt;
    }
    /**
     * getter for Allowance for employee retirement
     * @return Allowance for employee retirement
     */
    @Column(name = "allowance_for_employee_retirement", nullable = true, insertable = true, updatable = true)
    public Long getAllowanceForEmployeeRetirement() {
        return this.allowanceForEmployeeRetirement;
    }
    /**
     * setter for Allowance for employee retirement
     * @param aAllowanceForEmployeeRetirement Allowance for employee retirement
     */
    public void setAllowanceForEmployeeRetirement(Long aAllowanceForEmployeeRetirement) {
        this.allowanceForEmployeeRetirement = aAllowanceForEmployeeRetirement;
    }
    /**
     * getter for Allowance for director retirement benefits
     * @return Allowance for director retirement benefits
     */
    @Column(name = "allowance_for_director_retirement_benefits", nullable = true, insertable = true, updatable = true)
    public Long getAllowanceForDirectorRetirementBenefits() {
        return this.allowanceForDirectorRetirementBenefits;
    }
    /**
     * setter for Allowance for director retirement benefits
     * @param aAllowanceForDirectorRetirementBenefits Allowance for director retirement benefits
     */
    public void setAllowanceForDirectorRetirementBenefits(Long aAllowanceForDirectorRetirementBenefits) {
        this.allowanceForDirectorRetirementBenefits = aAllowanceForDirectorRetirementBenefits;
    }
    /**
     * getter for Special Repair Reserve
     * @return Special Repair Reserve
     */
    @Column(name = "special_repair_reserve", nullable = true, insertable = true, updatable = true)
    public Long getSpecialRepairReserve() {
        return this.specialRepairReserve;
    }
    /**
     * setter for Special Repair Reserve
     * @param aSpecialRepairReserve Special Repair Reserve
     */
    public void setSpecialRepairReserve(Long aSpecialRepairReserve) {
        this.specialRepairReserve = aSpecialRepairReserve;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.bondsPayable) + nvl(this.longTermDebt) + nvl(this.allowanceForEmployeeRetirement)
                + nvl(this.allowanceForDirectorRetirementBenefits) + nvl(this.specialRepairReserve);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
