// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Receivables
 * @author nilcy
 */
@Embeddable
public class Receivables implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 7912692927100394209L;
    /** Notes Receivable */
    private Long notesReceivable;
    /** Accounts Receivable */
    private Long accountsReceivable;
    /** Loans Receivable */
    private Long loansReceivable;
    /** Receivable */
    private Long receivable;
    /** Accrued Revenue */
    private Long accruedRevenue;
    /**
     * getter for Notes Receivable
     * @return Notes Receivable
     */
    @Column(name = "notes_receivable", nullable = true, insertable = true, updatable = true)
    public Long getNotesReceivable() {
        return this.notesReceivable;
    }
    /**
     * setter for Notes Receivable
     * @param aNotesReceivable Notes Receivable
     */
    public void setNotesReceivable(Long aNotesReceivable) {
        this.notesReceivable = aNotesReceivable;
    }
    /**
     * getter for Accounts Receivable
     * @return Accounts Receivable
     */
    @Column(name = "accounts_receivable", nullable = true, insertable = true, updatable = true)
    public Long getAccountsReceivable() {
        return this.accountsReceivable;
    }
    /**
     * setter for Accounts Receivable
     * @param aAccountsReceivable Accounts Receivable
     */
    public void setAccountsReceivable(Long aAccountsReceivable) {
        this.accountsReceivable = aAccountsReceivable;
    }
    /**
     * getter for Loans Receivable
     * @return Loans Receivable
     */
    @Column(name = "loans_receivable", nullable = true, insertable = true, updatable = true)
    public Long getLoansReceivable() {
        return this.loansReceivable;
    }
    /**
     * setter for Loans Receivable
     * @param aLoansReceivable Loans Receivable
     */
    public void setLoansReceivable(Long aLoansReceivable) {
        this.loansReceivable = aLoansReceivable;
    }
    /**
     * getter for Receivable
     * @return Receivable
     */
    @Column(name = "receivable", nullable = true, insertable = true, updatable = true)
    public Long getReceivable() {
        return this.receivable;
    }
    /**
     * setter for Receivable
     * @param aReceivable Receivable
     */
    public void setReceivable(Long aReceivable) {
        this.receivable = aReceivable;
    }
    /**
     * getter for Accrued Revenue
     * @return Accrued Revenue
     */
    @Column(name = "accrued_revenue", nullable = true, insertable = true, updatable = true)
    public Long getAccruedRevenue() {
        return this.accruedRevenue;
    }
    /**
     * setter for Accrued Revenue
     * @param aAccruedRevenue Accrued Revenue
     */
    public void setAccruedRevenue(Long aAccruedRevenue) {
        this.accruedRevenue = aAccruedRevenue;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.notesReceivable) + nvl(this.accountsReceivable) + nvl(this.loansReceivable)
                + nvl(this.receivable) + nvl(this.accruedRevenue);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
