// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Non-Receivables
 * @author nilcy
 */
@Embeddable
public class NonReceivables implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -8045085994747053379L;
    /** Advances */
    private Long advances;
    /** Prepaid Expense */
    private Long prepaidExpense;
    /**
     * getter for Advances
     * @return Advances
     */
    @Column(name = "advances", nullable = true, insertable = true, updatable = true)
    public Long getAdvances() {
        return this.advances;
    }
    /**
     * setter for Advances
     * @param aAdvances Advances
     */
    public void setAdvances(Long aAdvances) {
        this.advances = aAdvances;
    }
    /**
     * getter for Prepaid Expense
     * @return Prepaid Expense
     */
    @Column(name = "prepaid_expense", nullable = true, insertable = true, updatable = true)
    public Long getPrepaidExpense() {
        return this.prepaidExpense;
    }
    /**
     * setter for Prepaid Expense
     * @param aPrepaidExpense Prepaid Expense
     */
    public void setPrepaidExpense(Long aPrepaidExpense) {
        this.prepaidExpense = aPrepaidExpense;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.advances) +  nvl(this.prepaidExpense);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
