// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Investments and other assets
 * @author nilcy
 */
@Embeddable
public class InvestmentsAndOtherAssets implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 1935313868142920159L;
    /** Long-term prepaid expenses */
    private Long longTermPrepaidExpenses;
    /** Long-term loans receivable */
    private Long longTermLoansReceivable;
    /** Investment stocks & bonds */
    private Long investmentStocksAndBonds;
    /**
     * getter for Long-term prepaid expenses
     * @return Long-term prepaid expenses
     */
    @Column(name = "long_term_prepaid_expenses", nullable = true, insertable = true, updatable = true)
    public Long getLongTermPrepaidExpenses() {
        return this.longTermPrepaidExpenses;
    }
    /**
     * setter for Long-term prepaid expenses
     * @param aLongTermPrepaidExpenses Long-term prepaid expenses
     */
    public void setLongTermPrepaidExpenses(Long aLongTermPrepaidExpenses) {
        this.longTermPrepaidExpenses = aLongTermPrepaidExpenses;
    }
    /**
     * getter for Long-term loans receivable
     * @return Long-term loans receivable
     */
    @Column(name = "long_term_loans_receivable", nullable = true, insertable = true, updatable = true)
    public Long getLongTermLoansReceivable() {
        return this.longTermLoansReceivable;
    }
    /**
     * setter for Long-term loans receivable
     * @param aLongTermLoansReceivable Long-term loans receivable
     */
    public void setLongTermLoansReceivable(Long aLongTermLoansReceivable) {
        this.longTermLoansReceivable = aLongTermLoansReceivable;
    }
    /**
     * getter for Investment stocks & bonds
     * @return Investment stocks & bonds
     */
    @Column(name = "investment_stocks_and_bonds", nullable = true, insertable = true, updatable = true)
    public Long getInvestmentStocksAndBonds() {
        return this.investmentStocksAndBonds;
    }
    /**
     * setter for Investment stocks & bonds
     * @param aInvestmentStocksAndBonds Investment stocks & bonds
     */
    public void setInvestmentStocksAndBonds(Long aInvestmentStocksAndBonds) {
        this.investmentStocksAndBonds = aInvestmentStocksAndBonds;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.longTermPrepaidExpenses) + nvl(this.longTermLoansReceivable)
                + nvl(this.investmentStocksAndBonds);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
