// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.fin.bs.BalanceSheet;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
/**
 * Asset
 * @author nilcy
 */
@Entity
@Table(name = "bs_asset")
public class Asset extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -1182560670808231910L;
    /** Balance Sheet */
    private BalanceSheet balanceSheet;
    /** Current Assets */
    private CurrentAssets currentAssets;
    /** Fixed Asset */
    private FixedAsset fixedAsset;
    /** Deferred Assets */
    private DeferredAsset deferredAsset;
    /**
     * getter for Balance Sheet
     * @return Balance Sheet
     */
    @OneToOne(optional = false)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public BalanceSheet getBalanceSheet() {
        return this.balanceSheet;
    }
    /**
     * setter for Balance Sheet
     * @param aBalanceSheet Balance Sheet
     */
    public void setBalanceSheet(BalanceSheet aBalanceSheet) {
        this.balanceSheet = aBalanceSheet;
    }
    /**
     * getter for Current Assets
     * @return Current Assets
     */
    @Embedded
    public CurrentAssets getCurrentAssets() {
        return this.currentAssets;
    }
    /**
     * setter for Current Assets
     * @param aCurrentAssets Current Assets
     */
    public void setCurrentAssets(CurrentAssets aCurrentAssets) {
        this.currentAssets = aCurrentAssets;
    }
    /**
     * getter for Fixed Asset
     * @return Fixed Asset
     */
    @Embedded
    public FixedAsset getFixedAsset() {
        return this.fixedAsset;
    }
    /**
     * setter for Fixed Asset
     * @param aFixedAsset Fixed Asset
     */
    public void setFixedAsset(FixedAsset aFixedAsset) {
        this.fixedAsset = aFixedAsset;
    }
    /**
     * getter for Deferred Assets
     * @return Deferred Assets
     */
    @Embedded
    public DeferredAsset getDeferredAsset() {
        return this.deferredAsset;
    }
    /**
     * setter for Deferred Assets
     * @param aDeferredAsset Deferred Assets
     */
    public void setDeferredAsset(DeferredAsset aDeferredAsset) {
        this.deferredAsset = aDeferredAsset;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return ((this.currentAssets == null) ? 0L : this.currentAssets.sum())
                + ((this.fixedAsset == null) ? 0L : this.fixedAsset.sum())
                + ((this.deferredAsset == null) ? 0L : this.deferredAsset.sum());
    }
}
