// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Helper.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp;
import kuzumeji.entity.Person;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
/**
 * Helper
 * @author nilcy
 */
@Entity
@Table(name = "helper")
@Inheritance(strategy = InheritanceType.JOINED)
public class Helper extends Person {
    /** S/N */
    private static final long serialVersionUID = 7522991017307400274L;
    /** Partner */
    private Partner partner;
    /**
     * Constructor
     */
    public Helper() {
        // NOP
    }
    /**
     * @return Partner
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "partner_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Partner getPartner() {
        return this.partner;
    }
    /**
     * @param aPartner Partner
     */
    public void setPartner(Partner aPartner) {
        this.partner = aPartner;
    }
}
