// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Person.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.hibernate.validator.Length;
/**
 * Person
 * @author nilcy
 */
@Entity
@Table(name = "person")
@Inheritance(strategy = InheritanceType.JOINED)
public class Person extends ResourceEntity implements ContactMarker {
    /** S/N */
    private static final long serialVersionUID = 2341471068763837096L;
    /** Person Code */
    private String code;
    /** Person Name */
    private String name;
    /** Person Nick */
    private String nick;
    /** Note */
    private String note;
    /** Contact */
    private Contact contact = new Contact();
    /**
     * Constructor
     */
    public Person() {
        // NOP
    }
    /**
     * @return Person Code
     */
    @Column(name = "code", nullable = true, insertable = true, updatable = true)
    public String getCode() {
        return this.code;
    }
    /**
     * @param aCode Person Code
     */
    public void setCode(String aCode) {
        this.code = aCode;
    }
    /**
     * getter for Person Name
     * @return Person Name
     */
    @Column(name = "name", nullable = true, insertable = true, updatable = true)
    public String getName() {
        return this.name;
    }
    /**
     * setter for Person Name
     * @param aName Person Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * getter for Person nick
     * @return Person nick
     */
    @Column(name = "nick", nullable = true, insertable = true, updatable = true)
    public String getNick() {
        return this.nick;
    }
    /**
     * setter for Person nick
     * @param aNick Person nick
     */
    public void setNick(String aNick) {
        this.nick = aNick;
    }
    /**
     * @return Note
     */
    @Column(name = "note", nullable = true, insertable = true, updatable = true)
    @Length(max = 1000)
    public String getNote() {
        return this.note;
    }
    /**
     * @param aNote Note
     */
    public void setNote(String aNote) {
        this.note = aNote;
    }
    /**
     * @return Contact
     */
    @Embedded
    public Contact getContact() {
        return this.contact;
    }
    /**
     * @param aContact Contact
     */
    public void setContact(Contact aContact) {
        this.contact = aContact;
    }
}
