// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: BaseEntity.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
/**
 * Base Entity
 * @author nilcy
 */
@MappedSuperclass
public class BaseEntity implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -4701396186272292856L;
    /** ID */
    private Long id;
    /** Verno */
    private Long verno;
    /** Constructor */
    public BaseEntity() {
        // NOP
    }
    /**
     * getter for ID
     * @return ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id", nullable = false)
    public Long getId() {
        return this.id;
    }
    /**
     * setter for ID
     * @param aId ID
     */
    public void setId(Long aId) {
        this.id = aId;
    }
    /**
     * getter for Verno
     * @return Verno
     */
    @Version
    @Column(name = "verno", nullable = false)
    public Long getVerno() {
        return this.verno;
    }
    /**
     * setter for Verno
     * @param aVerno Verno
     */
    public void setVerno(Long aVerno) {
        this.verno = aVerno;
    }
    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
    /**
     * @see java.lang.Object#clone()
     */
    @Override
    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}
