package kuzumeji.dto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.ActualWork;
import org.apache.commons.lang.time.DateUtils;
/**
 * WorkDate
 * @author nilcy
 */
public class WorkDate implements Serializable {
    /** S/N */
    private static final long serialVersionUID = 4003614794606321508L;
    /** Person */
    private Person person;
    /** Date */
    private Date date;
    /** ActualWork List */
    private List<ActualWork> actualWorks = new ArrayList<ActualWork>(0);
    /**
     * CONSTRUCTOR
     * @param aPerson
     * @param aDate
     * @param aActualWorks
     */
    public WorkDate(Person aPerson, Date aDate, List<ActualWork> aActualWorks) {
        this.person = aPerson;
        this.date = aDate;
        if (aActualWorks == null) return;
        for (ActualWork actualWork : aActualWorks) {
            if (DateUtils.isSameDay(aDate, actualWork.getWorkDate())) {
                this.actualWorks.add(actualWork);
            }
        }
    }
    /**
     * @return Person
     */
    public Person getWorker() {
        return this.person;
    }
    /**
     * @return Date
     */
    public Date getDate() {
        return this.date;
    }
    /**
     * @return actualWorks
     */
    public List<ActualWork> getActualWorkDetails() {
        return this.actualWorks;
    }
}
