package kuzumeji.dto;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
/**
 * @author nilcy
 */
public class FileUpload {
    /** File List */
    private ArrayList<File> files = new ArrayList<File>();
    /** Uploads Available */
    private int uploadsAvailable = 5;
    /** Auto Upload Flag */
    private boolean autoUpload = false;
    /** Use Flash Flag */
    private boolean useFlash = false;
    /**
     * File Size
     * @return File Size
     */
    public int getSize() {
        if (getFiles().size() > 0) {
            return getFiles().size();
        }
        return 0;
    }
    /**
     * CONSTRUCTOR
     */
    public FileUpload() {
        // NOP
    }
    /**
     * paint
     * @param aStream stream
     * @param aObject object
     * @throws IOException
     */
    public void paint(OutputStream aStream, Object aObject) throws IOException {
        aStream.write(getFiles().get((Integer) aObject).getData());
    }
    /**
     * Listener
     * @param aEvent event
     * @throws Exception
     */
    public void listener(UploadEvent aEvent) throws Exception {
        UploadItem item = aEvent.getUploadItem();
        File file = new File();
        file.setLength(item.getData().length);
        file.setName(item.getFileName());
        file.setData(item.getData());
        this.files.add(file);
        this.uploadsAvailable--;
    }
    /**
     * clear upload data
     * @return null
     */
    public String clearUploadData() {
        this.files.clear();
        setUploadsAvailable(5);
        return null;
    }
    /**
     * Current Time Stamp
     * @return Current Time Stamp
     */
    public long getTimeStamp() {
        return System.currentTimeMillis();
    }
    /**
     * @return File List
     */
    public ArrayList<File> getFiles() {
        return this.files;
    }
    /**
     * @param aFiles File List
     */
    public void setFiles(ArrayList<File> aFiles) {
        this.files = aFiles;
    }
    /**
     * @return Uploads Available
     */
    public int getUploadsAvailable() {
        return this.uploadsAvailable;
    }
    /**
     * @param aUploadsAvailable Uploads Available
     */
    public void setUploadsAvailable(int aUploadsAvailable) {
        this.uploadsAvailable = aUploadsAvailable;
    }
    /**
     * @return Auto Upload Flag
     */
    public boolean isAutoUpload() {
        return this.autoUpload;
    }
    /**
     * @param aAutoUpload Auto Upload Flag
     */
    public void setAutoUpload(boolean aAutoUpload) {
        this.autoUpload = aAutoUpload;
    }
    /**
     * @return Use Flash Flag
     */
    public boolean isUseFlash() {
        return this.useFlash;
    }
    /**
     * @param aUseFlash Use Flash Flag
     */
    public void setUseFlash(boolean aUseFlash) {
        this.useFlash = aUseFlash;
    }
}
