// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id$
// ============================================================
package kuzumeji.dto;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.event.ValueChangeEvent;
import org.richfaces.model.CalendarDataModel;
import org.richfaces.model.CalendarDataModelItem;
/**
 * CalendarDataModelImpl
 * @author nilcy
 */
public class CalendarDataModelImpl implements CalendarDataModel {
    /** items */
    private CalendarDataModelItem[] items;
    /** currentDescription */
    private String currentDescription;
    /** currentShortDescription */
    private String currentShortDescription;
    /** currentDate */
    private Date currentDate;
    /** currentDisabled */
    private boolean currentDisabled;
    /**
     * @see org.richfaces.model.CalendarDataModel#getData(java.util.Date[])
     */
    @Override
    public CalendarDataModelItem[] getData(Date[] dateArray) {
        if (dateArray == null) { return null; }
        if (this.items == null) {
            this.items = new CalendarDataModelItem[dateArray.length];
            for (int i = 0; i < dateArray.length; i++) {
                this.items[i] = createDataModelItem(dateArray[i]);
            }
        }
        return this.items;
    }
    /**
     * createDataModelItem
     * @param aDate
     * @return CalendarDataModelItem
     */
    protected CalendarDataModelItem createDataModelItem(Date aDate) {
        CalendarDataModelItemImpl item = new CalendarDataModelItemImpl();
        Map<String, String> data = new HashMap<String, String>();
        data.put("shortDescription", "Nothing planned");
        data.put("description", "");
        Calendar c = Calendar.getInstance();
        c.setTime(aDate);
        item.setDay(c.get(Calendar.DAY_OF_MONTH));
        item.setEnabled(true);
        item.setStyleClass("rel-hol");
        item.setData(data);
        return item;
    }
    /**
     * @see org.richfaces.model.CalendarDataModel#getToolTip(java.util.Date)
     */
    @Override
    public Object getToolTip(Date aDate) {
        return null;
    }
    /**
     * getItems
     * @return items
     */
    public CalendarDataModelItem[] getItems() {
        return this.items;
    }
    /**
     * setter for items
     * @param aItems items
     */
    public void setItems(CalendarDataModelItem[] aItems) {
        this.items = aItems;
    }
    /**
     * valueChangeEvent handling
     * @param aEvent ValueChangeEvent
     */
    public void valueChanged(ValueChangeEvent aEvent) {
        System.out.println(aEvent.getNewValue() + "selected");
        setCurrentDate((Date) aEvent.getNewValue());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(getCurrentDate());
        setCurrentDescription((String) ((HashMap<?, ?>) this.items[calendar.get(Calendar.DAY_OF_MONTH) - 1].getData())
                .get("description"));
        setCurrentShortDescription((String) ((HashMap<?, ?>) this.items[calendar.get(Calendar.DAY_OF_MONTH) - 1]
                .getData()).get("shortDescription"));
    }
    /**
     * Storing changes action
     */
    @SuppressWarnings("unchecked")
    public void storeDayDetails() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(getCurrentDate());
        ((HashMap<String, String>) this.items[calendar.get(Calendar.DAY_OF_MONTH) - 1].getData()).put("shortDescription",
                getCurrentShortDescription());
        ((HashMap<String, String>) this.items[calendar.get(Calendar.DAY_OF_MONTH) - 1].getData()).put("description",
                getCurrentDescription());
    }
    /**
     * @return currentDescription
     */
    public String getCurrentDescription() {
        return this.currentDescription;
    }
    /**
     * @param aCurrentDescription
     */
    public void setCurrentDescription(String aCurrentDescription) {
        this.currentDescription = aCurrentDescription;
    }
    /**
     * @return currentDisabled
     */
    public boolean isCurrentDisabled() {
        return this.currentDisabled;
    }
    /**
     * @param aCurrentDisabled
     */
    public void setCurrentDisabled(boolean aCurrentDisabled) {
        this.currentDisabled = aCurrentDisabled;
    }
    /**
     * @return currentShortDescription
     */
    public String getCurrentShortDescription() {
        return this.currentShortDescription;
    }
    /**
     * @param aCurrentShortDescription
     */
    public void setCurrentShortDescription(String aCurrentShortDescription) {
        this.currentShortDescription = aCurrentShortDescription;
    }
    /**
     * @return currentDate
     */
    public Date getCurrentDate() {
        return this.currentDate;
    }
    /**
     * @param aCurrentDate
     */
    public void setCurrentDate(Date aCurrentDate) {
        this.currentDate = aCurrentDate;
    }
}
