// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: QuartzProcessor.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.async;
import java.util.Date;
import kuzumeji.entity.Contact;
import kuzumeji.service.FinderService;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.jboss.seam.framework.EntityController;
import org.jboss.seam.log.Log;
/**
 * QuartzProcessor
 * @author nilcy
 */
@Name("quartzProcessor")
@AutoCreate
public class QuartzProcessor extends EntityController {
    /** S/N */
    private static final long serialVersionUID = -1343870115254822058L;
    /** Logger */
    @Logger
    private Log log;
    /** QuartzTriggerHandle */
    @In
    QuartzTriggerHandle timer;
    /** Finder */
    @In(create = true)
    private FinderService finder;
    /** AsyncMailProcessor */
    // @In(create = true, required = true)
    @In
    private AsyncMailProcessor asyncMailProcessor;
    /** Admin Contact */
    private Contact contact;
    /** Create */
    @Create
    public void create() {
        this.contact = new Contact();
        this.contact.setMail("nilcy@mac.com");
        this.log.info("QuartzProcessor is Created. this.timer=[#0], this.finder=[#1], this.asyncMailProcessor=[#2]",
                this.timer, this.finder, this.asyncMailProcessor);
    }
    /**
     * @param aWhen
     * @param aCron
     * @return QuartzTriggerHandle
     */
    @Asynchronous
    public QuartzTriggerHandle scheduleAlerter(@Expiration Date aWhen, @IntervalCron String aCron) {
        this.log.info("scheduleAlerter() is Started.");
        try {
            BatchStarter.setSession();
            this.asyncMailProcessor.send(3000, this.contact, "/sys/NotifyMail.xhtml");
        } catch (Throwable t) {
            this.log.error(t.getLocalizedMessage(), t);
        } finally {
            this.log.info("scheduleAlerter() is Ended.");
        }
        return this.timer;
    }
    /**
     * @param exception
     */
    public void handleAsynchronousException(Exception exception) {
        this.log.fatal(exception);
    }
}
