// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: BatchStarter.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.async;
import java.util.Date;
import kuzumeji.entity.idm.User;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.framework.EntityController;
import org.jboss.seam.log.Log;
/**
 * BatchStarter
 * @author nilcy
 */
@Name("batchStarter")
@Scope(ScopeType.APPLICATION)
@Startup
public class BatchStarter extends EntityController {
    /** S/N */
    private static final long serialVersionUID = 7377174374102817106L;
    /** Logger */
    @Logger
    private Log log;
    /** QuartzProcessor */
    @In(create = true)
    private QuartzProcessor quartzProcessor;
    /** CRON_ALERTER */
    private static final String CRON_ALERTER = "0 */30 * * * ?";
    /**
     * Create
     * <ul>
     * <li>sec min hour day month week</li>
     * </ul>
     */
    @Create
    public void create() {
        this.log.info("BatchStarter is Created. CRON_ALERTER=[#0]", CRON_ALERTER);
        this.quartzProcessor.scheduleAlerter(new Date(), CRON_ALERTER);
    }
    /** BATCH_USER */
    public static User BATCH_USER = new User();
    static {
        BATCH_USER.setAccount("BATCH");
        // Contexts.getSessionContext().set("loginUser", BATCH_USER);
    }
    /**
     * Set SESSION value named loginUser
     */
    public static void setSession() {
        Contexts.getSessionContext().set("loginUser", BATCH_USER);
    }
}
