// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: OptionList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.sys;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.sys.Option;
import org.jboss.seam.annotations.Name;
/**
 * Option List
 * @author nilcy
 */
@Name("optionList")
public class OptionList extends BaseEntityQuery<Option> {
    /** S/N */
    private static final long serialVersionUID = -651880209079713244L;
    /** EJB-QL */
    private static final String EJBQL = "select option from Option option";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(option.cat) like (concat(#{optionList.option.cat},'%'))",
            "(option.key) like (concat(#{optionList.option.key},'%'))",
            "(option.val) like (concat(#{optionList.option.val},'%'))", };
    /** FILTER */
    private Option option = new Option();
    /** CONSTRUCTOR */
    public OptionList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Option getOption() {
        return this.option;
    }
}
