// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: CustomerList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Customer;
import org.jboss.seam.annotations.Name;
/**
 * Customer List
 * @author nilcy
 */
@Name("customerList")
public class CustomerList extends BaseEntityQuery<Customer> {
    /** S/N */
    private static final long serialVersionUID = -6227521618228660816L;
    /** EJB-QL */
    private static final String EJBQL = "select customer from Customer customer";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(customer.code) like (concat(#{customerList.customer.code},'%'))",
            "(customer.name) like (concat(#{customerList.customer.name},'%'))",
            "(customer.nick) like (concat(#{customerList.customer.nick},'%'))",
            "(customer.note) like (concat(#{customerList.customer.note},'%'))",
            "(customer.contact.zip)   like (concat(#{customerList.customer.contact.zip},'%'))", 
            "(customer.contact.addr1)  like (concat(#{customerList.customer.contact.addr1},'%'))",
            "(customer.contact.addr2) like (concat(#{customerList.customer.contact.addr2},'%'))",
            "(customer.contact.tel)   like (concat(#{customerList.customer.contact.tel},'%'))",
            "(customer.contact.mail)  like (concat(#{customerList.customer.contact.mail},'%'))",
            "(customer.contact.web)   like (concat(#{customerList.customer.contact.web},'%'))",};
    /** FILTER */
    private Customer customer = new Customer();
    /** CONSTRUCTOR */
    public CustomerList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Customer getCustomer() {
        return this.customer;
    }
}
