// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: BaseEntityQuery.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list;
import kuzumeji.entity.Contact;
import kuzumeji.entity.ContactMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.seam.annotations.In;
import org.jboss.seam.framework.EntityQuery;
/**
 * BaseEntityQuery
 * @author nilcy
 * @param <E> Entity
 */
public class BaseEntityQuery<E> extends EntityQuery<E> {
    /** S/N */
    private static final long serialVersionUID = 6545908231611253807L;
    /** EntityManager */
    @In
    EntityManager em;
    /** DEFAULT_MAX_RESULTS */
    private static final int DEFAULT_MAX_RESULTS = 5;
    /** full Result List */
    private List<E> fullResultList = new ArrayList<E>(0);
    /**
     * CONSTRUCTOR
     * @param aEjbql EJB-QL
     * @param aRestrictions RESTRICTIONS
     */
    public BaseEntityQuery(String aEjbql, String[] aRestrictions) {
        setEjbql(aEjbql);
        setRestrictionExpressionStrings(Arrays.asList(aRestrictions));
        setFirstResult(0);
        setMaxResults(DEFAULT_MAX_RESULTS);
    }
    /**
     * initialize FirstResult
     */
    public void initFirstResult() {
        setFirstResult(0);
    }
    /**
     * @return Current Page
     */
    public long getCurPage() {
        Integer firstResult = getFirstResult();
        if (firstResult == null || firstResult < 0) { return 0L; }
        Integer maxResults = getMaxResults();
        if (maxResults == null || maxResults <= 0) { return 1L; }
        long page = (firstResult + 1) / maxResults;
        return (firstResult + 1) % maxResults > 0 ? page + 1 : page;
    }
    /**
     * @return Page Size
     */
    public long getPageSize() {
        Long resultCount = getResultCount();
        if (resultCount == null || resultCount <= 0) { return 0L; }
        Integer maxResults = getMaxResults();
        if (maxResults == null || maxResults <= 0) { return 1L; }
        long page = resultCount / maxResults;
        return resultCount % maxResults > 0 ? page + 1 : page;
    }
    /**
     * @return Full Result List
     */
    public List<?> getFullResultList() {
        if (isAnyParameterDirty() || this.fullResultList == null) {
            setMaxResults(null);
            setFirstResult(0);
            this.fullResultList = this.findFullResultList();
        }
        return this.fullResultList;
    }
    /**
     * @return Full Result List
     */
    protected List<E> findFullResultList() {
        return getResultList();
    }
    @Override
    public void refresh() {
        super.refresh();
        this.fullResultList = null;
    }
    /**
     * @see org.jboss.seam.framework.EntityQuery#getEntityManager()
     */
    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }
    /**
     * @see org.jboss.seam.framework.EntityQuery#getResultList()
     */
    @Override
    public List<E> getResultList() {
        List<E> list = super.getResultList();
        for (E e : list) {
            if (e instanceof ContactMarker) {
                ((ContactMarker) e).setContact(new Contact());
            }
        }
        return list;
    }
}
