package kuzumeji.action.home.erp.mng;
import java.util.ArrayList;
import java.util.List;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.action.home.erp.WorkerHome;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.Activity;
import kuzumeji.entity.erp.mng.ActualExpense;
import kuzumeji.entity.erp.mng.ActualPeriod;
import kuzumeji.entity.erp.mng.ActualWork;
import kuzumeji.entity.erp.mng.Period;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
@Name("actualPeriodHome")
public class ActualPeriodHome extends BaseEntityHome<ActualPeriod> {
    @In(create = true)
    ActivityHome activityHome;
    @In(create = true)
    PeriodHome periodHome;
    @In(create = true)
    WorkerHome workerHome;
    public void setActualPeriodId(Long id) {
        setId(id);
    }
    public Long getActualPeriodId() {
        return (Long) getId();
    }
    @Override
    protected ActualPeriod createInstance() {
        ActualPeriod actualPeriod = new ActualPeriod();
        return actualPeriod;
    }
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    public void wire() {
        getInstance();
        Activity activity = activityHome.getDefinedInstance();
        if (activity != null) {
            getInstance().setActivity(activity);
        }
        Period period = periodHome.getDefinedInstance();
        if (period != null) {
            getInstance().setPeriod(period);
        }
        Person person = workerHome.getDefinedInstance();
        if (person != null) {
            getInstance().setWorker(person);
        }
    }
    public boolean isWired() {
        if (getInstance().getActivity() == null) return false;
        if (getInstance().getPeriod() == null) return false;
        if (getInstance().getWorker() == null) return false;
        return true;
    }
    public ActualPeriod getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
    public List<ActualExpense> getActualExpenses() {
        return getInstance() == null ? null : new ArrayList<ActualExpense>(getInstance().getActualExpenses());
    }
    public List<ActualWork> getActualWorks() {
        return getInstance() == null ? null : new ArrayList<ActualWork>(getInstance().getActualWorks());
    }
}
