package kuzumeji.action.home.erp.mng;
import java.util.ArrayList;
import java.util.List;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.action.home.erp.CustomerHome;
import kuzumeji.action.home.erp.TeamHome;
import kuzumeji.entity.erp.Customer;
import kuzumeji.entity.erp.Team;
import kuzumeji.entity.erp.mng.Activity;
import kuzumeji.entity.erp.mng.ActualPeriod;
import kuzumeji.entity.erp.mng.PlanExpense;
import kuzumeji.entity.erp.mng.PlanWork;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
@Name("activityHome")
public class ActivityHome extends BaseEntityHome<Activity> {
    @In(create = true)
    CustomerHome customerHome;
    @In(create = true)
    TeamHome teamHome;
    public void setActivityId(Long id) {
        setId(id);
    }
    public Long getActivityId() {
        return (Long) getId();
    }
    @Override
    protected Activity createInstance() {
        Activity activity = new Activity();
        return activity;
    }
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    public void wire() {
        getInstance();
        Customer customer = customerHome.getDefinedInstance();
        if (customer != null) {
            getInstance().setCustomer(customer);
        }
        Team team = teamHome.getDefinedInstance();
        if (team != null) {
            getInstance().setTeam(team);
        }
    }
    public boolean isWired() {
        return true;
    }
    public Activity getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
    public List<ActualPeriod> getActualPeriods() {
        return getInstance() == null ? null : new ArrayList<ActualPeriod>(getInstance().getActualPeriods());
    }
    public List<PlanExpense> getPlanExpenses() {
        return getInstance() == null ? null : new ArrayList<PlanExpense>(getInstance().getPlanExpenses());
    }
    public List<PlanWork> getPlanWorks() {
        return getInstance() == null ? null : new ArrayList<PlanWork>(getInstance().getPlanWorks());
    }
}
