// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: TypeList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import kuzumeji.entity.def.ActivityRole;
import kuzumeji.entity.def.ApprovalSts;
import kuzumeji.entity.def.DateCat;
import kuzumeji.entity.def.ExpenseCat;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
/**
 * Type List
 * @author nilcy
 */
@Startup
@Scope(ScopeType.APPLICATION)
@Name("typeList")
public class TypeList {
    /** Logger */
    @Logger
    private Log log;
    /**
     * @return ActivityRole List
     */
    public List<SelectItem> getActivityRoleList() {
        return createSelectList(ActivityRole.values());
    }
    /**
     * @return ApprovalSts List
     */
    public List<SelectItem> getApprovalStsList() {
        return createSelectList(ApprovalSts.values());
    }
    /**
     * @return DateCat List
     */
    public List<SelectItem> getDateCatList() {
        return createSelectList(DateCat.values());
    }
    /**
     * @return ExpenseCat List
     */
    public List<SelectItem> getExpenseCatList() {
        return createSelectList(ExpenseCat.values());
    }
    /**
     * @param aEnums Enum Values
     * @return Select List
     */
    private List<SelectItem> createSelectList(Enum<?>... aEnums) {
        List<SelectItem> items = new ArrayList<SelectItem>(0);
        for (Enum<?> e : aEnums) {
            items.add(new SelectItem(e.name(), e.name()));
        }
        this.log.info("Select List is created. [#0]", aEnums.toString());
        return items;
    }
}
