/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval.cummulative;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CummulativeAnnotationsItem
extends SimpleAnnotationsItem {
    private MetaDataContext context;
    private boolean includeParent;
    private long validTime;

    public CummulativeAnnotationsItem(MetaDataContext context, boolean includeParent) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.context = context;
        this.includeParent = includeParent;
        this.init(context.getValidTime().getValidTime());
    }

    @Override
    public Annotation[] getValue() {
        this.checkValid();
        return super.getValue();
    }

    @Override
    public AnnotationItem<? extends Annotation>[] getAnnotations() {
        this.checkValid();
        return super.getAnnotations();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    protected void checkValid() {
        AnnotationItem<? extends Annotation>[] items = super.getAnnotations();
        boolean valid = items != null;
        long newValidTime = this.context.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            valid = false;
        }
        if (valid && items != null) {
            for (AnnotationItem<? extends Annotation> item : items) {
                if (item.isValid()) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.init(newValidTime);
        }
    }

    protected void init(long validTime) {
        HashSet<AnnotationItem<? extends Annotation>> temp = null;
        List<MetaDataRetrieval> retrievals = this.includeParent ? this.context.getRetrievals() : this.context.getLocalRetrievals();
        for (MetaDataRetrieval retrieval : retrievals) {
            AnnotationItem<? extends Annotation>[] items;
            AnnotationsItem item = retrieval.retrieveAnnotations();
            if (item == null) continue;
            for (AnnotationItem<? extends Annotation> it : items = item.getAnnotations()) {
                if (temp == null) {
                    temp = new HashSet<AnnotationItem<? extends Annotation>>();
                }
                temp.add(it);
            }
        }
        AnnotationItem[] items = NO_ANNOTATION_ITEMS;
        if (temp != null) {
            items = temp.toArray(new AnnotationItem[temp.size()]);
        }
        this.setAnnotationItems(items);
        this.validTime = validTime;
    }
}

