/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.GenericAnnotationResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.annotations.ScopedAnnotationEnvironmentDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredAnnotationEnvironmentDeployer
extends ScopedAnnotationEnvironmentDeployer {
    private ResourceFilter resourceFilter;
    private ResourceFilter recurseFilter;

    public FilteredAnnotationEnvironmentDeployer() {
        this.addInput(ResourceFilter.class.getName() + ".resource");
        this.addInput(ResourceFilter.class.getName() + ".recurse");
    }

    protected <T> T getFilter(DeploymentUnit unit, Class<T> expectedClass, String suffix, T defaultValue) {
        String name = expectedClass.getName() + "." + (suffix != null ? suffix : "");
        Object result = unit.getAttachment(name, expectedClass);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    @Override
    protected void visitModule(VFSDeploymentUnit unit, Module module, GenericAnnotationResourceVisitor visitor) throws DeploymentException {
        ResourceFilter filter = this.getFilter((DeploymentUnit)unit, ResourceFilter.class, "resource", this.resourceFilter);
        if (filter == null) {
            filter = visitor.getFilter();
        }
        ResourceFilter recurse = this.getFilter((DeploymentUnit)unit, ResourceFilter.class, "recurse", this.recurseFilter);
        try {
            module.visit((ResourceVisitor)visitor, filter, recurse, this.getUrls(unit));
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Exception visiting module", (Throwable)e);
        }
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setRecurseFilter(ResourceFilter recurseFilter) {
        this.recurseFilter = recurseFilter;
    }
}

