/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.deployer.kernel;

import java.util.Collection;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataDeployer
extends AbstractSimpleRealDeployer<BeanMetaData> {
    private Controller controller;

    public BeanMetaDataDeployer(Kernel kernel) {
        super(BeanMetaData.class);
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.init((Controller)kernel.getController());
    }

    public BeanMetaDataDeployer(Controller controller) {
        super(BeanMetaData.class);
        this.init(controller);
    }

    protected void init(Controller controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.setComponentsOnly(true);
        this.setUseUnitName(true);
    }

    public void deploy(DeploymentUnit unit, BeanMetaData deployment) throws DeploymentException {
        if (deployment.getClassLoader() == null) {
            try {
                unit.getClassLoader();
                deployment.setClassLoader((ClassLoaderMetaData)new DeploymentClassLoaderMetaData(unit));
            }
            catch (Exception e) {
                this.log.debug((Object)("Unable to retrieve classloader for deployment: " + unit.getName() + " reason=" + e.toString()));
            }
        }
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, deployment, null);
        ScopeInfo scopeInfo = context.getScopeInfo();
        scopeInfo.setScope(unit.getScope());
        scopeInfo.setMutableScope(unit.getMutableScope());
        try {
            this.controller.install((ControllerContext)context);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment.getName()), (Throwable)t);
        }
    }

    protected static void mergeScopes(ScopeKey contextKey, ScopeKey unitKey) {
        if (contextKey == null) {
            return;
        }
        if (unitKey == null) {
            return;
        }
        Collection unitScopes = unitKey.getScopes();
        if (unitScopes == null || unitScopes.isEmpty()) {
            return;
        }
        for (Scope scope : unitScopes) {
            contextKey.addScope(scope);
        }
    }

    public void undeploy(DeploymentUnit unit, BeanMetaData deployment) {
        this.controller.uninstall((Object)deployment.getName());
        ClassLoaderMetaData classLoader = deployment.getClassLoader();
        if (classLoader instanceof DeploymentClassLoaderMetaData) {
            deployment.setClassLoader(null);
        }
    }

    private class DeploymentClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;
        private DeploymentUnit unit;

        public DeploymentClassLoaderMetaData(DeploymentUnit unit) {
            if (unit == null) {
                throw new IllegalArgumentException("Null unit");
            }
            this.unit = unit;
        }

        public ValueMetaData getClassLoader() {
            return new AbstractValueMetaData((Object)this.unit.getClassLoader());
        }
    }
}

