/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.aop.classpool.AbstractIsLocalResourcePlugin;
import org.jboss.aop.classpool.DelegatingClassPool;

public class URLClassLoaderIsLocalResourcePlugin
extends AbstractIsLocalResourcePlugin {
    String[] urls;

    public URLClassLoaderIsLocalResourcePlugin(DelegatingClassPool pool) {
        super(pool);
    }

    public boolean isMyResource(String resourceName) {
        URL url = this.getPool().getClassLoader().getResource(resourceName);
        if (url != null) {
            String urlString = url.toString();
            for (String s : this.urls) {
                if (!urlString.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected void initialise() {
        ClassLoader loader = this.getPool().getClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            throw new IllegalStateException("Not a URLClassLoader " + loader);
        }
        URL[] loaderUrls = ((URLClassLoader)loader).getURLs();
        this.urls = new String[loaderUrls.length];
        for (int i = 0; i < loaderUrls.length; ++i) {
            this.urls[i] = loaderUrls[i].toString();
        }
    }
}

