/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.net.URL;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.classpool.IsLocalResourcePlugin;
import org.jboss.aop.classpool.IsLocalResourcePluginFactoryRegistry;
import org.jboss.logging.Logger;

public class DelegatingClassPool
extends AOPClassPool {
    private static final Logger logger = Logger.getLogger(DelegatingClassPool.class);
    private final ClassPoolDomain domain;
    private boolean isTemp;
    private boolean closed;
    private IsLocalResourcePlugin isLocalResourcePlugin;

    public DelegatingClassPool(ClassPoolDomain domain, ClassLoader cl, ScopedClassPoolRepository repository, boolean isTemp) {
        super(cl, null, repository);
        this.domain = domain;
        domain.addClassPool(this);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
    }

    protected DelegatingClassPool(ClassPoolDomain domain, ClassLoader cl, ScopedClassPoolRepository repository) {
        super(cl, null, repository);
        this.domain = domain;
        domain.addClassPool(this);
        this.isLocalResourcePlugin = IsLocalResourcePluginFactoryRegistry.getPluginFactory(cl).create(this);
    }

    public CtClass get(String classname) throws NotFoundException {
        System.out.println("==> Initiating lookup of " + classname + " in " + (Object)((Object)this));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Initiating lookup of " + classname + " in " + (Object)((Object)this)));
        }
        return super.get(classname);
    }

    protected synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        CtClass clazz = null;
        if (useCache && (clazz = this.getCached(classname)) != null) {
            return clazz;
        }
        return this.createCtClass(classname, useCache);
    }

    public boolean isUnloadedClassLoader() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        super.close();
        this.domain.removeClassPool(this);
    }

    public CtClass getCached(String classname) {
        return this.getCached(true, classname);
    }

    CtClass getCached(boolean isInitiatingPool, String classname) {
        CtClass clazz;
        if (isInitiatingPool && this.domain.isParentFirst() && (clazz = this.domain.getCached(this, classname)) != null) {
            return clazz;
        }
        clazz = this.getCachedLocally(classname);
        if (clazz != null) {
            System.out.println("==> Found cached class " + classname + " in " + (Object)((Object)this));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found cached class " + classname + " in " + (Object)((Object)this)));
            }
            return clazz;
        }
        if (clazz == null) {
            Object o;
            boolean isLocal = false;
            ClassLoader cl = this.getClassLoader0();
            if (cl != null) {
                isLocal = this.isLocalResource(classname);
            }
            if (!isLocal && (o = this.generatedClasses.get(classname)) == null && isInitiatingPool) {
                return this.domain.getCached(this, classname);
            }
        }
        return null;
    }

    protected CtClass createCtClass(String classname, boolean useCache) {
        return this.createCtClass(true, classname, useCache);
    }

    CtClass createCtClass(boolean isInitiatingPool, String classname, boolean useCache) {
        CtClass clazz = null;
        if (this.isLocalResource(classname)) {
            URL classUrl = this.find(classname);
            boolean create = true;
            if (this.domain.isParentFirst() && this.domain.findParentResource(classname) != null) {
                create = false;
            }
            if (create && (clazz = super.createCtClass(classname, useCache)) != null && useCache && useCache) {
                System.out.println("==> Caching class " + classname + " in " + (Object)((Object)this));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Caching class " + classname + " in " + (Object)((Object)this)));
                }
                this.cacheCtClass(clazz.getName(), clazz, false);
            }
        }
        if (clazz == null && isInitiatingPool) {
            return this.domain.createCtClass(this, classname, useCache);
        }
        return clazz;
    }

    protected boolean isLocalResource(String resourceName) {
        return super.isLocalResource(resourceName);
    }

    public boolean isLocalClassLoaderResource(String classResourceName) {
        return this.isLocalResourcePlugin.isMyResource(classResourceName);
    }

    public boolean isLocalClassLoaderClass(String classname) {
        return this.isLocalResourcePlugin.isMyResource(this.getResourceName(classname));
    }

    public String toString() {
        return super.toString() + " domain: " + this.domain;
    }
}

