/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.DelegatingClassPool;

public class ClassPoolDomain {
    private String domainName;
    private ClassPoolDomain parent;
    private List<DelegatingClassPool> delegatingPools = new ArrayList<DelegatingClassPool>();
    private ClassPoolDomainStrategy classPoolDomainStrategy;
    private boolean parentFirst;

    public ClassPoolDomain(String domainName, ClassPoolDomain parent) {
        this.parent = parent;
        this.domainName = domainName;
        this.classPoolDomainStrategy = parent == null ? new RootClassPoolDomainImpl() : new ChildClassPoolDomainImpl();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    synchronized void addClassPool(DelegatingClassPool pool) {
        if (!this.delegatingPools.contains((Object)pool)) {
            this.delegatingPools.add(pool);
        }
    }

    synchronized void removeClassPool(DelegatingClassPool pool) {
        this.delegatingPools.remove((Object)pool);
    }

    synchronized CtClass getCached(DelegatingClassPool initiating, String classname) {
        CtClass clazz;
        if (this.parentFirst && (clazz = this.classPoolDomainStrategy.getParentCached(classname)) != null) {
            return clazz;
        }
        for (DelegatingClassPool pool : this.delegatingPools) {
            if (pool == initiating) continue;
            if (pool.isUnloadedClassLoader()) {
                AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                continue;
            }
            CtClass clazz2 = pool.getCached(false, classname);
            if (clazz2 == null) continue;
            return clazz2;
        }
        if (!this.parentFirst) {
            return this.classPoolDomainStrategy.getParentCached(classname);
        }
        return null;
    }

    synchronized CtClass createCtClass(DelegatingClassPool initiating, String classname, boolean useCache) {
        CtClass clazz;
        if (this.parentFirst && (clazz = this.createParentCtClass(classname, useCache)) != null) {
            return clazz;
        }
        for (DelegatingClassPool pool : this.delegatingPools) {
            if (pool == initiating) continue;
            if (pool.isUnloadedClassLoader()) {
                AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                continue;
            }
            CtClass clazz2 = pool.createCtClass(false, classname, useCache);
            if (clazz2 == null) continue;
            return clazz2;
        }
        if (!this.parentFirst) {
            return this.createParentCtClass(classname, useCache);
        }
        return null;
    }

    synchronized CtClass createParentCtClass(String classname, boolean useCache) {
        return this.classPoolDomainStrategy.createParentCtClass(classname, useCache);
    }

    synchronized URL findParentResource(String classname) {
        return this.classPoolDomainStrategy.findParentResource(classname);
    }

    synchronized URL findResource(String classname) {
        URL url;
        if (this.parentFirst && (url = this.classPoolDomainStrategy.findParentResource(classname)) != null) {
            return url;
        }
        for (DelegatingClassPool pool : this.delegatingPools) {
            URL url2;
            if (pool.isUnloadedClassLoader()) {
                AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                continue;
            }
            if (!pool.isLocalClassLoaderClass(classname) || (url2 = pool.find(classname)) == null) continue;
            return url2;
        }
        if (!this.parentFirst) {
            return this.classPoolDomainStrategy.findParentResource(classname);
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[" + this.domainName + "]";
    }

    private class ChildClassPoolDomainImpl
    implements ClassPoolDomainStrategy {
        private ChildClassPoolDomainImpl() {
        }

        public URL findParentResource(String classname) {
            return ClassPoolDomain.this.parent.findResource(classname);
        }

        public CtClass createParentCtClass(String classname, boolean useCache) {
            return ClassPoolDomain.this.parent.createCtClass(null, classname, useCache);
        }

        public CtClass getParentCached(String classname) {
            return ClassPoolDomain.this.parent.getCached(null, classname);
        }
    }

    private class RootClassPoolDomainImpl
    implements ClassPoolDomainStrategy {
        ClassPool defaultPool = ClassPool.getDefault();

        private RootClassPoolDomainImpl() {
        }

        public URL findParentResource(String classname) {
            return this.defaultPool.find(classname);
        }

        public CtClass createParentCtClass(String classname, boolean useCache) {
            try {
                return this.defaultPool.get(classname);
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        }

        public CtClass getParentCached(String classname) {
            try {
                return this.defaultPool.get(classname);
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        }
    }

    private static interface ClassPoolDomainStrategy {
        public URL findParentResource(String var1);

        public CtClass createParentCtClass(String var1, boolean var2);

        public CtClass getParentCached(String var1);
    }
}

