/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers.managed;

import java.io.Serializable;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.system.deployers.managed.ManagementObjectClass;
import org.jboss.system.deployers.managed.SecurityActions;
import org.jboss.system.metadata.ServiceAnnotationMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaDataICF
implements InstanceClassFactory<ServiceMetaData> {
    private static final Logger log = Logger.getLogger(ServiceMetaDataICF.class);
    private static final String MOCLASS_ANNOTATION = '@' + ManagementObjectClass.class.getName();
    private MBeanServer mbeanServer;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Class<ServiceMetaData> getType() {
        return ServiceMetaData.class;
    }

    public Class<? extends Serializable> getManagedObjectClass(ServiceMetaData md) throws ClassNotFoundException {
        Class clazz;
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        try {
            ClassLoader loader = this.getServiceMetaDataCL(md);
            Class moClass = loader.loadClass(md.getCode());
            SecurityActions.setContextClassLoader(loader);
            List<ServiceAnnotationMetaData> samlist = md.getAnnotations();
            for (ServiceAnnotationMetaData sam : samlist) {
                String anString = sam.getAnnotation();
                if (!anString.startsWith(MOCLASS_ANNOTATION)) continue;
                Class originalClass = moClass;
                ManagementObjectClass moc = (ManagementObjectClass)sam.getAnnotationInstance(loader);
                moClass = moc.code();
                log.debug((Object)("Using alternate class '" + moClass + "' for class " + originalClass));
                break;
            }
            clazz = moClass;
            Object var12_12 = null;
        }
        catch (InstanceNotFoundException e) {
            try {
                throw new ClassNotFoundException("Failed to obtain mbean class loader", e);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                SecurityActions.setContextClassLoader(prevLoader);
                throw throwable;
            }
        }
        SecurityActions.setContextClassLoader(prevLoader);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, MetaData metaData, ServiceMetaData md) {
        String name = property.getMappedName();
        if (name == null) {
            name = property.getName();
        }
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        Object value = null;
        MetaValue mvalue = null;
        try {
            try {
                ClassLoader loader = this.getServiceMetaDataCL(md);
                SecurityActions.setContextClassLoader(loader);
                for (ServiceAttributeMetaData amd : md.getAttributes()) {
                    if (!amd.getName().equalsIgnoreCase(name)) continue;
                    value = amd.getValue();
                    break;
                }
                if (value == null) {
                    ObjectName mbean = md.getObjectName();
                    try {
                        value = this.getMbeanServer().getAttribute(mbean, name);
                    }
                    catch (AttributeNotFoundException e) {
                        String attribute = name;
                        attribute = Character.isUpperCase(name.charAt(0)) ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : Character.toUpperCase(name.charAt(0)) + name.substring(1);
                        try {
                            value = this.getMbeanServer().getAttribute(mbean, attribute);
                        }
                        catch (Exception e2) {
                            log.debug((Object)("Failed to get value from mbean for: " + attribute), (Throwable)e2);
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to get value from mbean for: " + name), (Throwable)e);
                    }
                }
                if (value instanceof ServiceTextValueMetaData) {
                    ServiceTextValueMetaData text = (ServiceTextValueMetaData)value;
                    value = text.getText();
                } else if (value instanceof ServiceDependencyValueMetaData) {
                    ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)value;
                    value = depends.getDependency();
                }
                PropertyInfo propertyInfo = beanInfo.getProperty(name);
                try {
                    mvalue = this.metaValueFactory.create(value, propertyInfo.getType());
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to get property value for bean: " + beanInfo.getName() + ", property: " + propertyInfo.getName()), (Throwable)e);
                    MetaValue metaValue = mvalue = this.metaValueFactory.create(null, propertyInfo.getType());
                    Object var15_18 = null;
                    SecurityActions.setContextClassLoader(prevLoader);
                    return metaValue;
                }
                Object var15_19 = null;
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Failed to obtain mbean class loader", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            SecurityActions.setContextClassLoader(prevLoader);
            throw throwable;
        }
        SecurityActions.setContextClassLoader(prevLoader);
        return mvalue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        try {
            try {
                String aname;
                ClassLoader loader = this.getServiceMetaDataCL(md);
                SecurityActions.setContextClassLoader(loader);
                String name = property.getMappedName();
                if (name == null) {
                    property.getName();
                }
                ServiceValueMetaData attributeValue = null;
                for (ServiceAttributeMetaData amd : md.getAttributes()) {
                    if (!amd.getName().equalsIgnoreCase(name)) continue;
                    attributeValue = amd.getValue();
                    break;
                }
                if (attributeValue == null && (aname = this.mapAttributeName(md, name)) != null) {
                    ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
                    attr.setName(aname);
                    md.addAttribute(attr);
                    attributeValue = new ServiceTextValueMetaData("");
                    attr.setValue(attributeValue);
                }
                if (attributeValue == null) throw new IllegalArgumentException("No matching attribute found: " + name + "/" + md);
                PropertyInfo propertyInfo = beanInfo.getProperty(name);
                Object plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
                if (attributeValue instanceof ServiceTextValueMetaData) {
                    ServiceTextValueMetaData text = (ServiceTextValueMetaData)attributeValue;
                    text.setText(String.valueOf(plainValue));
                } else {
                    if (!(value instanceof ServiceDependencyValueMetaData)) throw new IllegalArgumentException("Unhandled attribute value type: " + name + "/" + md + ", class=" + attributeValue.getClass());
                    ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)attributeValue;
                    depends.setDependency(String.valueOf(plainValue));
                }
                Object var13_14 = null;
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Failed to obtain mbean class loader", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            SecurityActions.setContextClassLoader(prevLoader);
            throw throwable;
        }
        SecurityActions.setContextClassLoader(prevLoader);
    }

    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        ObjectName objectName;
        if ((beanInfo == null || property == null || value == null) && (objectName = md.getObjectName()) != null) {
            return objectName.getCanonicalName();
        }
        return null;
    }

    private ClassLoader getServiceMetaDataCL(ServiceMetaData md) throws InstanceNotFoundException {
        ClassLoader loader = null;
        if (this.mbeanServer != null) {
            loader = this.mbeanServer.getClassLoader(md.getClassLoaderName());
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    private String mapAttributeName(ServiceMetaData md, String name) {
        ObjectName mbean = md.getObjectName();
        String attrName = null;
        try {
            this.mbeanServer.getAttribute(mbean, name);
            attrName = name;
        }
        catch (Exception e) {
            char c = name.charAt(0);
            name = Character.isLowerCase(c) ? Character.toUpperCase(c) + name.substring(1) : Character.toLowerCase(c) + name.substring(1);
            try {
                this.mbeanServer.getAttribute(mbean, name);
                attrName = name;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (attrName == null) {
            char c = name.charAt(0);
            name = Character.toUpperCase(c) + name.substring(1);
            return name;
        }
        return attrName;
    }
}

