/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.logging.Logger;
import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5ClassPool
extends AOPClassPool {
    Logger log = Logger.getLogger(JBoss5ClassPool.class);
    protected URL tempURL = null;
    protected final Object tmplock = new Object();
    boolean closed;

    protected JBoss5ClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, URL tmpURL) {
        super(cl, src, repository);
        this.tempURL = tmpURL;
    }

    protected JBoss5ClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        super(src, repository);
    }

    public boolean isUnloadedClassLoader() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> toClass(CtClass cc, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        this.lockInCache(cc);
        ClassLoader myloader = this.getClassLoader();
        if (myloader == null || this.tempURL == null) {
            return super.toClass(cc, loader, domain);
        }
        try {
            String classFileName = this.getResourceName(cc.getName());
            URL outputURL = new URL(this.tempURL.toString() + "/" + classFileName);
            Object object = this.tmplock;
            synchronized (object) {
                ByteArrayOutputStream byteout = new ByteArrayOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(byteout);
                out.write(cc.toBytecode());
                out.flush();
                out.close();
                byte[] classBytes = byteout.toByteArray();
                MemoryContextFactory factory = MemoryContextFactory.getInstance();
                factory.putFile(outputURL, classBytes);
                if (myloader instanceof BaseClassLoader) {
                    ((BaseClassLoader)myloader).clearBlackList(classFileName);
                }
                Class<?> clazz = myloader.loadClass(cc.getName());
                return clazz;
            }
        }
        catch (Exception e) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName() + " on " + (Object)((Object)this) + " loader:" + myloader);
            cfe.initCause(e);
            throw cfe;
        }
    }
}

