/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.HierarchyVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthenticDirEntryHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler,
HierarchyVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private List<VirtualFileHandler> entryChildren;
    private transient Map<String, VirtualFileHandler> entryMap;

    public SynthenticDirEntryHandler(VFSContext context, VirtualFileHandler parent, String entryName, long lastModified, URL url) throws IOException {
        super(context, parent, url, entryName);
        try {
            URL parentVfsUrl = parent.toVfsUrl();
            String vfsParentUrl = parentVfsUrl.toString();
            this.setVfsUrl(this.getChildVfsUrl(entryName, !vfsParentUrl.endsWith("/")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.cachedLastModified = lastModified;
    }

    @Override
    protected void initCacheLastModified() {
    }

    @Override
    public synchronized void addChild(VirtualFileHandler child) {
        if (this.entryChildren == null) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        this.entryChildren.add(child);
        if (this.entryMap != null) {
            this.entryMap.put(child.getName(), child);
        }
    }

    @Override
    public long getLastModified() throws IOException {
        this.checkParentExists();
        return this.getParent().getLastModified();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isHidden() {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return true;
    }

    @Override
    public boolean delete(int gracePeriod) {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        throw new IOException("Directories cannot be opened");
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        if (this.entryChildren == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entryChildren);
    }

    @Override
    public synchronized VirtualFileHandler createChildHandler(String name) throws IOException {
        if (this.entryChildren == null) {
            return null;
        }
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, VirtualFileHandler>();
            for (VirtualFileHandler child : this.entryChildren) {
                this.entryMap.put(child.getName(), child);
            }
        }
        return this.entryMap.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public boolean removeChild(String name) throws IOException {
        return false;
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        this.entryChildren.remove(original);
        this.entryChildren.add(replacement);
        this.entryMap.put(original.getName(), replacement);
    }
}

