/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.net.URL;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceVisitorDeployer
extends AbstractSimpleRealDeployer<Module> {
    private ResourceVisitor visitor;
    private ResourceFilter filter;
    private ResourceFilter recurseFilter;

    public AbstractResourceVisitorDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public AbstractResourceVisitorDeployer(ResourceVisitor visitor) {
        this();
        this.visitor = visitor;
    }

    public AbstractResourceVisitorDeployer(ResourceVisitor visitor, ResourceFilter filter) {
        this(visitor);
        this.filter = filter;
    }

    public AbstractResourceVisitorDeployer(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter) {
        this(visitor, filter);
        this.recurseFilter = recurseFilter;
    }

    public void deploy(DeploymentUnit unit, Module module) throws DeploymentException {
        ResourceFilter recurse;
        ResourceFilter currentFilter;
        ResourceVisitor currentVisitor = this.createVisitor(unit);
        if (currentVisitor == null) {
            currentVisitor = this.visitor;
        }
        if ((currentFilter = this.createFilter(unit)) == null) {
            currentFilter = this.filter;
        }
        if ((recurse = this.createRecurseFilter(unit)) == null) {
            currentFilter = this.recurseFilter;
        }
        this.visitModule(module, currentVisitor, currentFilter, recurse);
    }

    protected void visitModule(Module module, ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurse) {
        module.visit(visitor, filter, recurse, new URL[0]);
    }

    protected ResourceVisitor createVisitor(DeploymentUnit unit) {
        return null;
    }

    protected ResourceFilter createFilter(DeploymentUnit unit) {
        return null;
    }

    protected ResourceFilter createRecurseFilter(DeploymentUnit unit) {
        return null;
    }
}

