/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBAttachmentSerializer
extends AbstractFileAttachmentsSerializer {
    private static final Logger log = Logger.getLogger(JAXBAttachmentSerializer.class);
    private static final QName ROOT_NAME = new QName("attachment");
    private static final String ATTACHMENT_SUFFIX = ".attachment.xml";

    @Override
    protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{expected});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        if (PersistedManagedObject.class.getName().equals(expected.getName())) {
            this.hack(unmarshaller);
        }
        return (T)unmarshaller.unmarshal(attachmentsStore);
    }

    @Override
    protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception {
        log.trace((Object)("saveAttachments, attachmentsStore=" + attachmentsStore + ", attachment=" + attachment));
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{attachment.getClass()});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(attachment, attachmentsStore);
    }

    protected static <T> JAXBElement<T> createRootElement(Class<T> expected, Object o) {
        return new JAXBElement(ROOT_NAME, expected, o);
    }

    @Override
    protected File getAttachmentPath(String baseName) {
        String vfsPath = baseName + ATTACHMENT_SUFFIX;
        return new File(this.getAttachmentsStoreDir(), vfsPath);
    }

    private void hack(Unmarshaller unmarshaller) {
        unmarshaller.setListener((Unmarshaller.Listener)new PeristedManagedObjectHandler());
    }

    private static class PeristedManagedObjectHandler
    extends Unmarshaller.Listener {
        private PeristedManagedObjectHandler() {
        }

        public void afterUnmarshal(Object target, Object parent) {
            if (parent instanceof PersistedManagedObject) {
                if (target instanceof PersistedProperty) {
                    PersistedProperty p = (PersistedProperty)target;
                    ((PersistedManagedObject)parent).put(p.getName(), p);
                }
            } else if (parent instanceof PersistedCompositeValue && target instanceof PersistedValue) {
                PersistedValue v = (PersistedValue)target;
                ((PersistedCompositeValue)parent).put(v.getName(), v);
            }
        }
    }
}

