/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profile.basic.ProfileImpl;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public class MetaDataAwareProfile
extends ProfileImpl {
    private MainDeployerStructure mainDeployer;
    private VirtualFileFilter filter;
    private Map<String, Long> lastModifiedCache = new ConcurrentHashMap<String, Long>();

    public MetaDataAwareProfile(String profileRoot, ProfileKey key) {
        super(profileRoot, key);
    }

    public void setMainDeployer(MainDeployerStructure mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    protected boolean hasBeenModified(VirtualFile root) throws Exception {
        URI uri = VFSUtils.getCompatibleURI((VirtualFile)root);
        File file = new File(uri);
        if (file.isFile()) {
            return root.hasBeenModified();
        }
        String name = root.toURI().toString();
        VFSDeploymentContext deploymentContext = this.getDeploymentContext(name);
        if (deploymentContext != null) {
            return this.hasBeenModified(deploymentContext);
        }
        this.log.debug((Object)("Falling back to root name: " + root));
        deploymentContext = this.getDeploymentContext(root.getName());
        if (deploymentContext != null) {
            return this.hasBeenModified(deploymentContext);
        }
        return false;
    }

    protected boolean hasBeenModified(VFSDeploymentContext deploymentContext) throws IOException {
        List childContexts;
        List metadataLocations = deploymentContext.getMetaDataLocations();
        if (metadataLocations != null && !metadataLocations.isEmpty()) {
            for (VirtualFile metadataLocation : metadataLocations) {
                List children = metadataLocation.getChildren(this.filter);
                if (children == null || children.isEmpty()) continue;
                for (VirtualFile child : children) {
                    String pathName = child.getPathName();
                    Long timestamp = this.lastModifiedCache.get(pathName);
                    long lastModified = child.getLastModified();
                    this.lastModifiedCache.put(pathName, lastModified);
                    if (timestamp == null || timestamp >= lastModified) continue;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Metadata location modified: " + child));
                    }
                    return true;
                }
            }
        }
        if ((childContexts = deploymentContext.getChildren()) != null && !childContexts.isEmpty()) {
            for (DeploymentContext childContext : childContexts) {
                if (!(childContext instanceof VFSDeploymentContext) || !this.hasBeenModified((VFSDeploymentContext)childContext)) continue;
                return true;
            }
        }
        return false;
    }

    protected void postRemove(VFSDeployment deployment) throws Exception {
        VirtualFile root = deployment.getRoot();
        String pathName = root.getPathName();
        if (this.log.isTraceEnabled()) {
            this.log.debug((Object)("Removing last modified cache info for: " + pathName));
        }
        Iterator<String> iter = this.lastModifiedCache.keySet().iterator();
        while (iter.hasNext()) {
            if (!iter.next().startsWith(pathName)) continue;
            iter.remove();
        }
    }

    protected VFSDeploymentContext getDeploymentContext(String name) {
        if (this.mainDeployer == null) {
            throw new IllegalArgumentException("Null main deployer");
        }
        DeploymentContext deploymentContext = this.mainDeployer.getDeploymentContext(name);
        if (deploymentContext == null || !(deploymentContext instanceof VFSDeploymentContext)) {
            return null;
        }
        return (VFSDeploymentContext)deploymentContext;
    }
}

