class cfgWeapons
{
	class LauncherCore;
	class RocketPods 		: LauncherCore
	{
		scope 			= 1;
		type 			= 65536;
		canLock 		= 2;
		nameSound 		= "rockets";
		reloadTime 		= 0.2;
		autoFire 		= 1;
		minRange = 50;		minRangeProbab = 0.1;
		midRange = 600;		midRangeProbab = 0.25;
		maxRange = 2500;	maxRangeProbab = 0.05;
		cursorAim 		= "\ca\Weapons\Data\clear_empty";
		cursor 			= "Rocket";
		cursorSize 		= 1;
	};
	
	class JSDF_W_M261 		: RocketPods
	{
		magazines[] 		= {"JSDF_M_70mmFFARx19"};
		modes[] 		= {"Far_AI", "Burst"};
		
		class Far_AI 			: RocketPods
		{
			minRange = 50;		minRangeProbab = 0.041;
			midRange = 600;		midRangeProbab = 0.21;
			maxRange = 2500;	maxRangeProbab = 0.11;
			displayName 		= $STR_DN_HYDRA_SINGLE;
			sound[] 		= {"\ca\Sounds\weapons\cannon\RocketLauncher_Shot21", 3.16228, 1, 1100};
			soundFly[] 		= {"\ca\Sounds\weapons\cannon\rocket_fly1", 5.62341, 1.2, 700};
			burst 			= 2;
			reloadTime 		= 0.08;
			autoFire 		= 0;
			showToPlayer 		= 0;
		};
		class Burst 			: RocketPods
		{
			minRange = 1;		minRangeProbab = 0.001;
			midRange = 2;		midRangeProbab = 0.001;
			maxRange = 3;		maxRangeProbab = 0.001;
			displayName 		= $STR_DN_HYDRA_PAIR;
			burst 			= 1;
			reloadTime 		= 0.08;
			soundContinuous 	= 1;
			autoFire 		= 1;
			sound[] 		= {"\ca\Sounds\weapons\cannon\RocketLauncher_Shot21", 3.16228, 1, 1100};
			soundFly[] 		= {"\ca\Sounds\weapons\cannon\rocket_fly1", 5.62341, 1.2, 700};
		};
	};
	class JSDF_W_M261x2 		: JSDF_W_M261	{magazines[] = {"JSDF_M_70mmFFARx38"};};
	class JSDF_W_M261x4 		: JSDF_W_M261	{magazines[] = {"JSDF_M_70mmFFARx76"};};
	class MissileLauncher 		: LauncherCore
	{
		scope 			= 1;
		type 			= 65536;
		reloadTime 		= 0.5;
		nameSound 		= "MissileLauncher";
		cursorAim 		= "\ca\Weapons\Data\clear_empty";
		cursor 			= "Missile";
		cursorSize 		= 1;
	};
	class JSDF_W_M229 		: MissileLauncher
	{
		displayName 		= $STR_DN_HELLFIRE;
		minRange = 50;		minRangeProbab = 0.6;
		midRange = 2000;	midRangeProbab = 0.9;
		maxRange = 4000;	maxRangeProbab = 0.1;
		sound[] 		= {"\ca\Sounds\weapons\cannon\RocketLauncher_Shot05", 31.6228, 1, 1100};
		soundFly[] 		= {"\ca\Sounds\weapons\cannon\rocket_fly1", 100.0, 0.8, 800};
		reloadTime 		= 1;
		magazines[] 		= {"JSDF_M_M_AGM_114L"};
		aiRateOfFire 		= 5.0;
		aiRateOfFireDistance 	= 4000;
		cursorAim 		= "\ca\Weapons\Data\clear_empty";
		cursor 			= "Laser";
		cursorSize 		= 1;
	};
	class JSDF_W_M229x2 		: JSDF_W_M229	{magazines[] = {"JSDF_M_AGM_114Lx8"};};
	class JSDF_W_M229x4 		: JSDF_W_M229	{magazines[] = {"JSDF_M_AGM_114Lx16"};};
	class JSDF_W_ATAS 		: MissileLauncher
	{
		displayName 		= $STR_DN_STINGER;
		minRange = 50;		minRangeProbab = 0.3;
		midRange = 1000;	midRangeProbab = 0.8;
		maxRange = 4000;	maxRangeProbab = 0.1;
		aiRateOfFire 		= 5.0;
		aiRateOfFireDistance 	= 2500;
		sound[] 		= {"\ca\Sounds\weapons\cannon\Javelin_fire_v3_A", 10.0, 1, 1200};
		soundFly[] 		= {"\ca\Sounds\weapons\cannon\rocket_fly1", 10.0, 1.5, 700};
		reloadTime 		= 4;
		magazineReloadTime 	= 30;
		magazines[] 		= {"JSDF_M_ATAS"};
		cursorAim 		= "\ca\Weapons\Data\clear_empty";
		cursorSize 		= 1;
		cursor 			= "Stinger";
	};
};
