class CfgPatches {
	class JSDF_Air_C130H
	{
		units[] = {C130H};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"CAAir2"};
	};
};

class CfgVehicles {
	class Plane;	// External class reference
	
	class C130H : Plane
	{
		destrType = "DestructWreck";
		scope = 2;
		side = 1;
		displayname = $STR_DN_C130J;
		
		class Library {
			libTextDesc = $STR_LIB_C130J;
		};
		
		class Damage {
			tex[] = {};
			mat[] = {"ca\air2\C130J\DATA\c130j_sklo.rvmat", "ca\air2\C130J\DATA\c130j_sklo_damage.rvmat", "ca\air2\C130J\DATA\c130j_sklo_damage.rvmat", "ca\air2\C130J\DATA\c130j_sklo_in.rvmat", "ca\air2\C130J\DATA\c130j_sklo_in_damage.rvmat", "ca\air2\C130J\DATA\c130j_sklo_in_damage.rvmat", "ca\air2\C130J\DATA\c130j_body.rvmat", "ca\air2\C130J\DATA\c130j_body_damage.rvmat", "ca\air2\C130J\DATA\c130j_body_destruct.rvmat", "ca\air2\C130J\DATA\c130j_interior.rvmat", "ca\air2\C130J\DATA\c130j_interior_damage.rvmat", "ca\air2\C130J\DATA\c130j_interior_destruct.rvmat", "ca\air2\C130J\DATA\c130j_wings.rvmat", "ca\air2\C130J\DATA\c130j_wings_damage.rvmat", "ca\air2\C130J\DATA\c130j_wings_destruct.rvmat"};
		};
		vehicleClass = "Air";
		faction = USMC;
		model = "\ca\air2\c130j\c130j.p3d";
		picture = "\ca\air2\data\UI\picture_c130j_CA.paa";
		icon = "\ca\air2\data\UI\icon_c130j_CA.paa";
		mapSize = 25;
		maxSpeed = 648;
		accuracy = 0.15;
		cost = 20000;
		armor = 70;
		driverAction = "C130_Pilot";
		cargoAction[] = {"C130_Cargo", "Mi17_Cargo02"};
		crew = "USMC_Soldier_Pilot";
		typicalCargo[] = {"USMC_Soldier_Pilot", "USMC_Soldier"};
		transportSoldier = 25;
		driverCompartments = "Compartment1";
		cargoCompartments[] = {"Compartment1"};
		soundGetIn[] = {"ca\sounds\Air\C130\close", 0.316228, 1};
		soundGetOut[] = {"ca\sounds\Air\C130\open", 0.316228, 1, 40};
		soundDammage[] = {"ca\sounds\Air\C130\int-alarm_loop", 0.562341, 1};
		soundEngineOnInt[] = {"ca\sounds\Air\C130\int_start_1", 0.398107, 1.0};
		soundEngineOnExt[] = {"ca\sounds\Air\C130\ext_start_1", 0.398107, 1.0, 700};
		soundEngineOffInt[] = {"ca\sounds\Air\C130\int_stop_1", 0.398107, 1.0};
		soundEngineOffExt[] = {"ca\sounds\Air\C130\ext_stop_1", 0.398107, 1.0, 700};
		
		class Sounds {
			class EngineLowOut {
				sound[] = {"ca\sounds\Air\C130\ext_engine_low", 1.77828, 1, 900};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "camPos*engineOn*(rpm factor[0.85, 0])";
			};
			
			class EngineHighOut {
				sound[] = {"ca\sounds\Air\C130\ext_engine_hi", 1.77828, 1, 1100};
				frequency = "1";
				volume = "camPos*engineOn*(rpm factor[0.55, 1.0])";
			};
			
			class ForsageOut {
				sound[] = {"ca\sounds\Air\C130\ext_forsage_1", 1.41254, 1, 1500};
				frequency = "1";
				volume = "camPos*engineOn*(thrust factor[0.5, 1.0])";
				cone[] = {1.14, 3.92, 2.0, 0.4};
			};
			
			class WindNoiseOut {
				sound[] = {"ca\sounds\Air\C130\ext-wind1", 0.001, 0.6, 150};
				frequency = "(0.1+(1.2*(speed factor[1, 100])))";
				volume = "camPos*(speed factor[1, 100])";
			};
			
			class EngineLowIn {
				sound[] = {"ca\sounds\Air\C130\int_engine_low", 1.0, 1.0};
				frequency = "1.0 min (rpm + 0.5)";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.85, 0]))";
			};
			
			class EngineHighIn {
				sound[] = {"ca\sounds\Air\C130\int_engine_hi", 1.0, 1.0};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(rpm factor[0.55, 1.0]))";
			};
			
			class ForsageIn {
				sound[] = {"ca\sounds\Air\C130\int_forsage_1", 1.41254, 1.1};
				frequency = "1";
				volume = "(1-camPos)*(engineOn*(thrust factor[0.5, 1.0]))";
			};
			
			class WindNoiseIn {
				sound[] = {"ca\sounds\Air\C130\int-wind1", 0.001, 0.6};
				frequency = "(0.1+(1.2*(speed factor[1, 100])))";
				volume = "(1-camPos)*(speed factor[1, 100])";
			};
		};
		
		class Reflectors {
			class Left {
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "L svetlo";
				direction = "konec L svetla";
				hitpoint = "L svetlo";
				selection = "L svetlo";
				size = 1;
				brightness = 1.0;
			};
			
			class Right {
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "P svetlo";
				direction = "konec P svetla";
				hitpoint = "P svetlo";
				selection = "P svetlo";
				size = 1;
				brightness = 1.0;
			};
			
			class Left2 {
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "L2 svetlo";
				direction = "konec L2 svetla";
				hitpoint = "L2 svetlo";
				selection = "L2 svetlo";
				size = 1;
				brightness = 1.0;
			};
			
			class Right2 {
				color[] = {0.8, 0.8, 1.0, 1.0};
				ambient[] = {0.07, 0.07, 0.07, 1.0};
				position = "P2 svetlo";
				direction = "konec P2 svetla";
				hitpoint = "P2 svetlo";
				selection = "P2 svetlo";
				size = 1;
				brightness = 1.0;
			};
		};
		weapons[] = {};
		magazines[] = {};
		threat[] = {0.1, 0.5, 0.8};
		ejectSpeed[] = {0, 0, 0};
		landingAoa = "rad 7";
		landingSpeed = 200;
		extCameraPosition[] = {0, 5, -40};
		envelope[] = {0.0, 0.1, 0.5, 1.5, 3.1, 4.3, 4.9, 5, 4.4, 2.8, 1.6, 0.8, 0};
		flapsFrictionCoef = 2;
		wheelSteeringSensitivity = 0.5;
		aileronSensitivity = 1;
		elevatorSensitivity = 1;
		noseDownCoef = 1;
		gearUpTime = 4.5;
		gearDownTime = 3;
		
		class AnimationSources {
			class door_2_2 {
				source = "user";
				animPeriod = 2.5;
			};
			
			class door_2_1 : door_2_2 {};
			
			class door_1 : door_2_2 {};
			
			class ramp_top : door_2_2 {};
			
			class ramp_bottom : door_2_2 {};
		};
	};
};
