/*
	$Id: TwitterAPI.cs 85 2010-06-09 13:51:04Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using Hiyoko.Net.OAuth;

namespace Hiyoko.Net.Twitter{
	/// <summary>
	/// TwitterAPĨv~eBuȊ֐QB
	/// </summary>
	public static partial class TwitterAPI{
		
		// ConsumerKeyAConsumerSecret͔Jt@CŒ`B
		private static Consumer Consumer{get; set;}
		
		static TwitterAPI(){
			ServicePointManager.Expect100Continue = false;
			Consumer = new Consumer(ConsumerKey, ConsumerSecret);
		}
		
		#region API
		
		public static WebRequestData UpdateStatus(AccessToken token, string status, decimal replyTo, string source){
			const string url = "http://api.twitter.com/1/statuses/update.xml";
			List<Parameter> prms = new List<Parameter>();
			prms.Add(new Parameter("status", status));
			prms.Add(new Parameter("source", source));
			if(replyTo > 0){
				prms.Add(new Parameter("in_reply_to_status_id", replyTo.ToString()));
			}
			return Post(url, prms.ToArray(), token);
		}
		
		public static WebRequestData VerifyCredential(AccessToken token){
			const string url = "http://api.twitter.com/1/account/verify_credentials.xml";
			return Get(url, new Parameter[0], token);
		}
		
		public static WebRequestData GetHomeTimeline(AccessToken token, int count, int page, decimal sinceId, decimal maxId){
			const string url = "http://api.twitter.com/1/statuses/home_timeline.xml";
			List<Parameter> prms = new List<Parameter>();
			if(count > 0){
				prms.Add(new Parameter("count", count.ToString()));
			}
			if(page > 0){
				prms.Add(new Parameter("page", page.ToString()));
			}
			if(sinceId > 0){
				prms.Add(new Parameter("since_id", sinceId.ToString()));
			}
			if(maxId > 0){
				prms.Add(new Parameter("max_id", maxId.ToString()));
			}
			return Get(url, prms.ToArray(), token);
		}
		
		public static WebRequestData GetUserTimeline(AccessToken token, string id, int count, int page, decimal sinceId, decimal maxId){
			const string url = "http://api.twitter.com/1/statuses/user_timeline.xml";
			List<Parameter> prms = new List<Parameter>();
			if(!String.IsNullOrEmpty(id)){
				prms.Add(new Parameter("id", id));
			}
			if(count > 0){
				prms.Add(new Parameter("count", count.ToString()));
			}
			if(page > 0){
				prms.Add(new Parameter("page", page.ToString()));
			}
			if(sinceId > 0){
				prms.Add(new Parameter("since_id", sinceId.ToString()));
			}
			if(maxId > 0){
				prms.Add(new Parameter("maxId", maxId.ToString()));
			}
			return Get(url, prms.ToArray(), token);
		}
		
		public static WebRequestData DestroyStatus(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/statuses/destroy";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData CreateFavorite(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/favorites/create";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData CreateBlock(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/blocks/create";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData DestroyBlock(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/blocks/destroy";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData CreateFriendship(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/friendships/create";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData DestroyFriendship(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/friendships/destroy";
			Parameter[] prms = new Parameter[1]{new Parameter("id", id.ToString())};
			return Post(url + "/" + id.ToString() + ".xml", prms, token);
		}
		
		public static WebRequestData SearchUsers(AccessToken token, string searchWord, int count, int page){
			const string url = "http://api.twitter.com/1/users/search.xml";
			List<Parameter> prms = new List<Parameter>();
			prms.Add(new Parameter("q", searchWord));
			if(count > 0){
				prms.Add(new Parameter("per_page", count.ToString()));
			}
			if(page > 0){
				prms.Add(new Parameter("page", page.ToString()));
			}
			return Get(url, prms.ToArray(), token);
		}
		
		public static WebRequestData ShowUser(decimal id){
			return ShowUser(id.ToString());
		}
		
		public static WebRequestData ShowUser(string name){
			const string url = "http://api.twitter.com/1/users/show.xml";
			return Get(url, new Parameter[]{new Parameter("id", name)});
		}
		
		public static WebRequestData GetFollowers(AccessToken token, decimal user_id){
			return GetFollowers(token, user_id, -1);
		}
		
		public static WebRequestData GetFollowers(AccessToken token, decimal user_id, decimal cursor){
			const string url = "http://api.twitter.com/1/statuses/followers.xml";
			return Get(url, new Parameter[]{new Parameter("user_id", user_id.ToString()), new Parameter("cursor", cursor.ToString())}, token);
		}
		
		public static WebRequestData GetFriends(AccessToken token, decimal user_id){
			return GetFriends(token, user_id, -1);
		}
		
		public static WebRequestData GetFriends(AccessToken token, decimal user_id, decimal cursor){
			const string url = "http://api.twitter.com/1/statuses/friends.xml";
			return Get(url, new Parameter[]{new Parameter("user_id", user_id.ToString()), new Parameter("cursor", cursor.ToString())}, token);
		}
		
		public static WebRequestData GetBlocks(AccessToken token, int page){
			const string url = "http://api.twitter.com/1/blocks/blocking.xml";
			return Get(url, new Parameter[]{new Parameter("page", page.ToString())}, token);
		}
		
		public static WebRequestData Retweet(AccessToken token, decimal id){
			const string url = "http://api.twitter.com/1/statuses/retweet/";
			return Post(url + id.ToString() + ".xml", new Parameter[0], token);
		}
		
		#endregion
		
		#region ʐM
		
		private static WebRequestData Get(string url, Parameter[] prms){
			HttpWebRequest req = GetWebRequest(url + ((prms.Length > 0) ? ("?" + Parameter.ConCat(prms)) : ""), prms);
			req.Method = "GET";
			
			return new WebRequestData(req);
		}
		
		private static WebRequestData Post(string url, Parameter[] prms){
			string query = Parameter.ConCat(prms);
			byte[] data = Encoding.ASCII.GetBytes(query);
			
			HttpWebRequest req = GetWebRequest(url, prms);
			req.Method = "POST";
			req.ContentType = "application/x-www-form-urlencoded";
			req.ContentLength = query.Length;
			
			return new WebRequestData(req, data);
		}
		
		private static WebRequestData Get(string url, Parameter[] prms, AccessToken token){
			
			HttpWebRequest req = GetWebRequest(url + ((prms.Length > 0) ? ("?" + Parameter.ConCat(prms)) : ""), prms);
			req.Method = "GET";
			
			Consumer.AccessProtectedResource(token, req, url, "http://twitter.com/", prms);
			return new WebRequestData(req);
		}
		
		private static WebRequestData Post(string url, Parameter[] prms, AccessToken token){
			string query = Parameter.ConCat(prms);
			byte[] data = Encoding.ASCII.GetBytes(query);
			
			HttpWebRequest req = GetWebRequest(url, prms);
			req.Method = "POST";
			req.ContentType = "application/x-www-form-urlencoded";
			req.ContentLength = query.Length;
			
			Consumer.AccessProtectedResource(token, req, url, "http://twitter.com/", prms);
			return new WebRequestData(req, data);
		}
		
		private static HttpWebRequest GetWebRequest(string url, Parameter[] prms){
			HttpWebRequest req = (HttpWebRequest)HttpWebRequest.Create(url);
			req.KeepAlive = false;
			req.CookieContainer = null;
			req.Timeout = 15000;
			return req;
		}
		
		#region OAuth
		
		public static AccessToken GetAccessToken(RequestToken requestToken, string verifier){
			return Consumer.RequestAccessToken(
				verifier, requestToken, "http://api.twitter.com/oauth/access_token", "http://twitter.com/");
		}
		
		public static RequestToken ObtainUnauthorizedRequestToken(){
			return Consumer.ObtainUnauthorizedRequestToken("http://api.twitter.com/oauth/request_token", "http://twitter.com/");
		}
		
		public static string BuildUserAuthorizationURL(RequestToken reqToken){
			return Consumer.BuildUserAuthorizationURL("http://api.twitter.com/oauth/authorize", reqToken);
		}
		
		#endregion
		
		#region ̑
		/*
		private static string BuildUrl(string url, Parameter[] prms){
			return (prms.Length > 0) ? url + "?" + BuildQuery(prms) : url;
		}
		
		private static string BuildQuery(Parameter[] prms){
			var query = from prm in prms
			            select prm.Name + "=" + prm.Value;
			return String.Join("&", query.ToArray());
		}
		*/
		public static bool TryParseDateTime(string s, out DateTime result){
			const string format = @"ddd MMM dd HH':'mm':'ss zz'00' yyyy";
			return DateTime.TryParseExact(
				s,
				format,
				System.Globalization.DateTimeFormatInfo.InvariantInfo,
				System.Globalization.DateTimeStyles.AllowWhiteSpaces,
				out result);
		}
		/*
		public static bool TryParseColor(string s, out Color color){
			try{
				int n = Convert.ToInt32(s, 16);
				byte r = (byte)((n & 0xff0000) >> 16);
				byte g = (byte)((n & 0x00ff00) >> 8);
				byte b = (byte)((b & 0x0000ff));
				color = Color.FromRgb(r, g, b);
				return true;
			}catch{
				return false;
			}
		}
		*/
		
		public static string GetErrorMessage(WebException ex){
			if(ex.Status == WebExceptionStatus.ProtocolError){
				HttpWebResponse req = ex.Response as HttpWebResponse;
				if(req != null){
					switch(req.StatusCode){
						case HttpStatusCode.BadRequest:
							return "400: NGXgsAAPI̎gp𒴂Ă܂B";
						case HttpStatusCode.Unauthorized:
							return "401: AJEg̔F؂s܂BOAuthF؂蒼ĂB";
						case HttpStatusCode.Forbidden:
							return "403: T[o[ANZX֎~Ă܂BXV𒴂Ă\܂B";
						case HttpStatusCode.BadGateway:
							return "501: Twitter̃T[o[_EĂ邩AAbvf[głB";
						case HttpStatusCode.ServiceUnavailable:
							return "503: Twitter̃T[rXgpłȂԂɂ܂B΂炭ł蒼ĂB";
						default:
							return String.Format("{0}: {1}", (int)req.StatusCode, ex.Message);
					}
				}
			}
			return ex.Message;
		}
		
		#endregion
		
		private static IWebProxy proxy;
		public static IWebProxy Proxy{
			get{
				return proxy;
			}
			set{
				proxy = value;
				Consumer.Proxy = value;
			}
		}
		
		#endregion
	}
}