/*
	$Id: WpfComponents.cs 75 2010-03-06 10:07:32Z catwalk $
*/
using System;
using System.Linq;
using System.Globalization;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Input;
using System.Windows.Threading;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Net.Cache;
using Hiyoko.Net;
using Hiyoko.Net.Twitter;
using Hiyoko.Utilities;

namespace Hiyoko.Forms{
	#region Ro[^[
	
	public class Int32ToSolidColorBrushConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			byte a = (parameter == null) ? (byte)255 : Byte.Parse((string)parameter);
			int n = (int)value;
			byte r = (byte)((n >> 16) & 0xff);
			byte g = (byte)((n >>  8) & 0xff);
			byte b = (byte)( n & 0xff);
			return new SolidColorBrush(Color.FromArgb(a, r, g, b));
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class SolidColorBrushAlphaConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			var brush = (SolidColorBrush)value;
			var color = brush.Color;
			color.A = (byte)parameter;
			brush.Color = color;
			return brush;
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class DateTimeToStringConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			DateTime dt = (DateTime)value;
			return dt.ToString(Program.Settings.DateTimeFormat);
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class DateTimeToAgoStringConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			var span = DateTime.Now - (DateTime)value;
			if(span.Minutes <= 0){
				return "about " + span.Seconds.ToString() + " secondsO";
			}else if(span.Hours <= 0){
				return "about " + span.Minutes.ToString() + " minutesO";
			}else if(span.Days <= 0){
				return "about " + span.Hours.ToString() + " hoursO";
			}else{
				return "about " + span.Days.ToString() + " daysO";
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class RemoveHtmlTagsConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			string text = (string)value;
			if(String.IsNullOrEmpty(text)){
				return "";
			}else{
				return Regex.Replace(text, @"<.+?>", "");
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class ExtractUriConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			string text = (string)value;
			if(String.IsNullOrEmpty(text)){
				return "";
			}else{
				return text.ExtractUrls().FirstOrDefault();
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class StringIsNullOrEmptyConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			return String.IsNullOrEmpty((string)value);
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class UrlToImageSourceConverter : IValueConverter{
		//private IDictionary<string, BitmapImage> cache = new Dictionary<string, BitmapImage>();
		
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			string url = (string)value;
			BitmapImage bmp;
			/*if(this.cache.TryGetValue(url, out bmp)){
				return bmp;
			}else{*/
			if(url != null){
				bmp = new BitmapImage();
				bmp.BeginInit();
				bmp.UriSource = new Uri(url, UriKind.RelativeOrAbsolute);
				bmp.EndInit();
				return bmp;
			}else{
				return null;
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	/*
	public class CommandToInputGestureTextConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			FrameworkElement elm = (parameter as FrameworkElement) ??
			                       FocusManager.GetFocusedElement(Application.Current.MainWindow) as FrameworkElement ??
			                       Application.Current.MainWindow;
			ICommand cmd = (ICommand)value;
			var list = new List<string>();
			while(elm != null){
				foreach(var bind in elm.InputBindings.OfType<KeyBinding>().Where(bin => (bin.Command == cmd))){
					string text = ((KeyGesture)bind.Gesture).DisplayString;
					if(!String.IsNullOrEmpty(text)){
						list.Add(text);
					}
				}
				elm = elm.Parent as FrameworkElement;
			}
			return String.Join(", ", list.ToArray());
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	*/
	public class ExpandUrlsConverter : IValueConverter{
		public UrlShorter UrlShorter{get; set;}
		
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			if(this.UrlShorter != null){
				return this.UrlShorter.ExpandUrlsInText((string)value);
			}else{
				return value;
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			if(this.UrlShorter != null){
				return this.UrlShorter.ShortenUrlsInText((string)value);
			}else{
				return value;
			}
		}
	}
	
	public class ObjectOrDefaultConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			return (value == null) ? Activator.CreateInstance((Type)parameter) : value;
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class AccountToProfileBackgroundImageConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			Hiyoko.Net.Twitter.Account account = (Hiyoko.Net.Twitter.Account)value;
			if((account != null) && (account.User.ProfileBackgroundImageUrl != null)){
				ImageBrush brush = new ImageBrush();
				brush.ImageSource = new BitmapImage(new Uri(account.User.ProfileBackgroundImageUrl, UriKind.RelativeOrAbsolute));
				brush.TileMode = (account.User.ProfileBackgroundTile) ? TileMode.Tile : TileMode.None;
				brush.Stretch = Stretch.UniformToFill;
				return brush;
			}else{
				return null;
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class TwitterUserToUserHomeUriConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			if(value != null){
				User user = (User)value;
				return "http://twitter.com/" + user.ScreenName;
			}else{
				return "";
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class BooleanToVisibilityConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			return (bool)value ? Visibility.Visible : Visibility.Collapsed;
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class IsNullConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			return (value == null);
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class StatusToUrlConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			if(value != null){
				var status = (Status)value;
				return "http://twitter.com/" + status.User.ScreenName + "/status/" + status.Id;
			}else{
				return "";
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class TwitterStatusCountRemainsConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			return 140 - ((string)value).Length;
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class TwitterStatusCountStateConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			int count = 140 - ((string)value).Length;
			return (count < 10) ? 2 : (count < 20) ? 1 : 0;
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	public class CommandToInputGestureTextConverter : IValueConverter{
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			var command = (RoutedCommand)value;
			return String.Join(", ", command.InputGestures.Cast<KeyGesture>().Select(g => g.DisplayString).ToArray());
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
	
	#endregion
	
	#region ValidationRule
	
	public class Int32RangeRule : ValidationRule{
		public int Min{get; set;}
		public int Max{get; set;}
		
		public Int32RangeRule(){
			this.Min = Int32.MinValue;
			this.Max = Int32.MaxValue;
		}
		
		public override ValidationResult Validate(object value, CultureInfo cultureInfo){
			int n;
			if(Int32.TryParse((string)value, out n)){
				if((this.Min <= n) && (n <= this.Max)){
					return new ValidationResult(true, null);
				}else{
					return new ValidationResult(false, String.Format("{0}  {1} ̐l͈̔͂œ͂ĂB", this.Min, this.Max));
				}
			}else{
				return new ValidationResult(false, "l͂ĂB");
			}
		}
	}
	
	public class IsEmptyStringValidationRule : ValidationRule{
		public IsEmptyStringValidationRule(){
		}
		
		public override ValidationResult Validate(object value, CultureInfo cultureInfo){
			string s = (string)value;
			if(String.IsNullOrEmpty(s)){
				return new ValidationResult(false, "͓͂̕ł܂B");
			}else{
				return new ValidationResult(true, null);
			}
		}
	}
	
	#endregion
	
	#region Behaviour
	
	public static class TextBoxBehaviors{
		public static readonly DependencyProperty IsSelectAllOnFocusProperty =
			DependencyProperty.RegisterAttached("IsSelectAllOnFocus", typeof(bool), typeof(TextBoxBehaviors), new UIPropertyMetadata(false, IsSelectAllOnFocusChanged));
		
		[AttachedPropertyBrowsableForType(typeof(TextBoxBase))]
		public static bool GetIsSelectAllOnFocus(DependencyObject obj){
			return (bool)obj.GetValue(IsSelectAllOnFocusProperty);
		}
		
		[AttachedPropertyBrowsableForType(typeof(TextBoxBase))]
		public static void SetIsSelectAllOnFocus(DependencyObject obj, bool value){
			obj.SetValue(IsSelectAllOnFocusProperty, value);
		}
		
		private static void IsSelectAllOnFocusChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e){
			TextBoxBase textBox = (TextBoxBase)sender;
			
			bool newValue = (bool)e.NewValue;
			bool oldValue = (bool)e.OldValue;
			if(oldValue){
				textBox.GotFocus -= TextBox_GotFocus;
			}
			if(newValue){
				textBox.GotFocus += TextBox_GotFocus;
			}
		}
		
		private static void TextBox_GotFocus(object sender, RoutedEventArgs e){
			TextBoxBase textBox = (TextBoxBase)sender;
			textBox.Dispatcher.BeginInvoke(DispatcherPriority.Render, new Action(delegate{
				textBox.SelectAll();
			}));
		}
	}
	
	public class ButtonBehaviors{
		public static readonly DependencyProperty DropDownMenuProperty =
			DependencyProperty.RegisterAttached("DropDownMenu", typeof(ContextMenu), typeof(ButtonBehaviors), new UIPropertyMetadata(null, DropDownMenuChanged));
		
		[AttachedPropertyBrowsableForType(typeof(ButtonBase))]
		public static ContextMenu GetDropDownMenu(DependencyObject obj){
			return (ContextMenu)obj.GetValue(DropDownMenuProperty);
		}
		
		[AttachedPropertyBrowsableForType(typeof(ButtonBase))]
		public static void SetDropDownMenu(DependencyObject obj, bool value){
			if(GetDropDownMenu(obj) == null){
				ButtonBase button = (ButtonBase)obj;
				button.Click += Button_Click;
			}
			obj.SetValue(DropDownMenuProperty, value);
		}
		
		private static void DropDownMenuChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e){
			ButtonBase button = (ButtonBase)sender;
			
			if(e.OldValue == null){
				button.Click += Button_Click;
			}
		}
		
		private static void Button_Click(object sender, RoutedEventArgs e){
			ButtonBase button = (ButtonBase)sender;
			ContextMenu menu = GetDropDownMenu(button);
			if(menu != null){
				menu.PlacementTarget = button;
				menu.Placement = PlacementMode.Bottom; 
				menu.IsOpen = true;
			}
		}
	}
	
	#endregion
	
	#region Animation
	
	public class GridLengthAnimation : AnimationTimeline{
		public override Type TargetPropertyType{
			get{
				return typeof(GridLength);
			}
		}
		
		protected override System.Windows.Freezable CreateInstanceCore(){
			return new GridLengthAnimation();
		}
		
		public static readonly DependencyProperty FromProperty = DependencyProperty.Register("From", typeof(GridLength), typeof(GridLengthAnimation));
		public GridLength From
		{
			get{
				return (GridLength)GetValue(GridLengthAnimation.FromProperty);
			}
			set{
				SetValue(GridLengthAnimation.FromProperty, value);
			}
		}
		
		public static readonly DependencyProperty ToProperty = DependencyProperty.Register("To", typeof(GridLength), typeof(GridLengthAnimation));
		public GridLength To{
			get{
				return (GridLength)GetValue(GridLengthAnimation.ToProperty);
			}
			set{
				SetValue(GridLengthAnimation.ToProperty, value);
			}
		}
		
		public override object GetCurrentValue(object defaultOriginValue, object defaultDestinationValue, AnimationClock animationClock){
			double fromVal = ((GridLength)GetValue(GridLengthAnimation.FromProperty)).Value;
			double toVal = ((GridLength)GetValue(GridLengthAnimation.ToProperty)).Value;
			
			if (fromVal > toVal)
			{
				return new GridLength((1 - animationClock.CurrentProgress.Value) * (fromVal - toVal) + toVal, GridUnitType.Star);
			}
			else
				return new GridLength(animationClock.CurrentProgress.Value * (toVal - fromVal) + fromVal, GridUnitType.Star);
		}
	}
	
	#endregion
}