/*
	$Id: DisposableObject.cs 47 2010-01-24 10:45:48Z catwalk $
*/
using System;

namespace Hiyoko{
	public abstract class DisposableObject : IDisposable{
		public void Dispose(){
			this.Dispose(true);
			GC.SuppressFinalize(this);
		}
		
		protected virtual void Dispose(bool disposing){
		}
		
		~DisposableObject(){
			this.Dispose(false);
		}
	}
}