from System import *;
from System.Windows import *;
from System.Windows.Input import *;
from System.Windows.Threading import *;
from Hiyoko import *;

def Startup(sender):
	mainForm = Application.Current.MainWindow;
	BindKeys(mainForm);
	RefreshTimeline(mainForm);

def BindKeys(mainForm):
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.Close, KeyGesture(Key.Escape, ModifierKeys.None)));
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.AbortCommunication, KeyGesture(Key.Q, ModifierKeys.Control)));
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.Refresh, Key.F5, ModifierKeys.None));
	
	mainForm.TimelinePanel.InputBindings.Add(KeyBinding(HiyokoCommands.Refresh, Key.F5, ModifierKeys.None));
	
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(HiyokoCommands.UpdateStatus, Key.Enter, ModifierKeys.Control));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageUp, Key.PageUp, ModifierKeys.None));
	mainForm.TimelinePanel.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageDown, Key.PageDown, ModifierKeys.None));
	
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, Key.C, ModifierKeys.Control));
	mainForm.TimelinePanel.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, Key.Insert, ModifierKeys.Control));

def RefreshTimeline(mainForm):
	HiyokoCommands.Refresh.Execute(None, mainForm.TimelinePanel);

Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, Action[object](Startup), "");