/*
	$Id: Settings.cs 24 2010-01-17 19:44:31Z catwalk $
*/
using System;
using System.Linq;
using System.Configuration;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using Hiyoko.Net.OAuth;

namespace Hiyoko{
	public static class ApplicationSettingsBaseExtension{
		public static void CopyTo(this ApplicationSettingsBase source, ApplicationSettingsBase dest){
			foreach(SettingsProperty prop in source.Properties.Cast<SettingsProperty>()
			                                                  .Where(prop => (dest[prop.Name] != source[prop.Name]))){
				dest[prop.Name] = source[prop.Name];
			}
		}
	}
	
	public abstract class UpgradeOnceApplicationSettingBase : ApplicationSettingsBase{
		public UpgradeOnceApplicationSettingBase(){}
		public UpgradeOnceApplicationSettingBase(string key) : base(key){}
		
		[NoSettingsVersionUpgrade]
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public virtual bool IsUpgradedSettings{
			get{
				return (bool)this["IsUpgradedSettings"];
			}
			set{
				this["IsUpgradedSettings"] = value;
			}
		}
		
		protected override void OnSettingsLoaded(object sender, SettingsLoadedEventArgs e){
			base.OnSettingsLoaded(sender, e);
		}
		
		public void UpgradeOnce(){
			if(!this.IsUpgradedSettings){
				this.Upgrade();
				this.IsUpgradedSettings = true;
			}
		}
	}
	
	public class ApplicationSettings : UpgradeOnceApplicationSettingBase{
		public ApplicationSettings(){}
		public ApplicationSettings(string key) : base(key){}
		
		[UserScopedSetting]
		[DefaultSettingValue(null)]
		public string StartupScriptPath{
			get{
				return (string)this["StartupScriptPath"];
			}
			set{
				this["StartupScriptPath"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("15000")]
		public int ConnectionTimeout{
			get{
				return (int)this["ConnectionTimeout"];
			}
			set{
				this["ConnectionTimeout"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue(null)]
		[SettingsSerializeAs(SettingsSerializeAs.Binary)]
		public AccessToken AccessToken{
			get{
				return (AccessToken)this["AccessToken"];
			}
			set{
				this["AccessToken"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("yyyy-MM-dd ddd hh-mm-ss tt")]
		public string DateTimeFormat{
			get{
				return (string)this["DateTimeFormat"];
			}
			set{
				this["DateTimeFormat"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsResident{
			get{
				return (bool)this["IsResident"];
			}
			set{
				this["IsResident"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsAutoRefreshTimeline{
			get{
				return (bool)this["IsAutoRefreshTimeline"];
			}
			set{
				this["IsAutoRefreshTimeline"] = value;
			}
		}
		/*
		[UserScopedSetting]
		[DefaultSettingValue("60")]
		public int AutoRefreshTimelineInterval{
			get{
				return (int)this["AutoRefreshTimelineInterval"];
			}
			set{
				if(value < 60){
					throw new ArgumentOutOfRangeException();
				}
				this["AutoRefreshTimelineInterval"] = value;
			}
		}
		*/
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsUseUserColor{
			get{
				return (bool)this["IsUseUserColor"];
			}
			set{
				this["IsUseUserColor"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("20")]
		public int TimelineCount{
			get{
				return (int)this["TimelineCount"];
			}
			set{
				if((value < 1) && (value > 200)){
					throw new ArgumentOutOfRangeException();
				}
				this["TimelineCount"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public DateTime LatestTimelineStatusDateTime{
			get{
				return (DateTime)this["LatestTimelineStatusDateTime"];
			}
			set{
				this["LatestTimelineStatusDateTime"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("64")]
		public int OutputItemLimitCount{
			get{
				return (int)this["OutputItemLimitCount"];
			}
			set{
				if(value <= 0){
					throw new ArgumentOutOfRangeException();
				}
				this["OutputItemLimitCount"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("64")]
		public GridLength OutputListRowHeight{
			get{
				return (GridLength)this["OutputListRowHeight"];
			}
			set{
				this["OutputListRowHeight"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("auto")]
		public GridLength TimelineStatusEditRowHeight{
			get{
				return (GridLength)this["TimelineStatusEditRowHeight"];
			}
			set{
				this["TimelineStatusEditRowHeight"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public bool IsUseWebProxy{
			get{
				return (bool)this["IsUseWebProxy"];
			}
			set{
				this["IsUseWebProxy"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue(null)]
		public Uri WebProxyUri{
			get{
				return (Uri)this["WebProxyUri"];
			}
			set{
				this["WebProxyUri"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string BitlyLogin{
			get{
				return (string)this["BitlyLogin"];
			}
			set{
				this["BitlyLogin"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string BitlyApiKey{
			get{
				return (string)this["BitlyApiKey"];
			}
			set{
				this["BitlyApiKey"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string TwitpicUsername{
			get{
				return (string)this["TwitpicUsername"];
			}
			set{
				this["TwitpicUsername"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string TwitpicPassword{
			get{
				return (string)this["TwitpicPassword"];
			}
			set{
				this["TwitpicPassword"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public bool IsUseProfileBackground{
			get{
				return (bool)this["IsUseProfileBackground"];
			}
			set{
				this["IsUseProfileBackground"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		[SettingsSerializeAs(SettingsSerializeAs.Binary)]
		public Key ShowWindowHotKey{
			get{
				return (Key)this["ShowWindowHotKey"];
			}
			set{
				this["ShowWindowHotKey"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		[SettingsSerializeAs(SettingsSerializeAs.Binary)]
		public ModifierKeys ShowWindowHotKeyModifiers{
			get{
				return (ModifierKeys)this["ShowWindowHotKeyModifiers"];
			}
			set{
				this["ShowWindowHotKeyModifiers"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue(null)]
		public Uri ThemeUri{
			get{
				return (Uri)this["ThemeUri"];
			}
			set{
				this["ThemeUri"] = value;
			}
		}
	}
	
	/// <summary>
	/// EChE̐ݒNX
	/// </summary>
	public class WindowSettings : UpgradeOnceApplicationSettingBase{
		public WindowSettings(){}
		public WindowSettings(string key) : base(key){}
		
		[UserScopedSetting]
		[DefaultSettingValue("NaN, NaN, 640, 480")]
		public Rect RestoreBounds{
			get{
				return VerifyRect((Rect)this["RestoreBounds"]);
			}
			set{
				this["RestoreBounds"] = value;
			}
		}
		
		private Rect VerifyRect(Rect rect){
			Double width = rect.Width;
			Double height = rect.Height;
			Double x = rect.X;
			Double y = rect.Y;
			if(!ValidSizeValue(rect.Width)){
				width = 640;
			}
			if(!ValidSizeValue(rect.Height)){
				height = 480;
			}
			if(!ValidPositionValue(rect.X)){
				x = Double.NaN;
			}
			if(!ValidPositionValue(rect.Y)){
				y = Double.NaN;
			}
			return new Rect(width, height, x, y);
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("Normal")]
		public WindowState WindowState{
			get{
				return (WindowState)this["WindowState"];
			}
			set{
				if(value == WindowState.Minimized){
					throw new ArgumentException();
				}
				this["WindowState"] = value;
			}
		}
		
		private static bool ValidSizeValue(double v){
			return ValidPositionValue(v);
		}
		
		private static bool ValidPositionValue(double v){
			return ((Double.NegativeInfinity < v) && (v < Double.PositiveInfinity));
		}
	}
}