/*
	$Id: TwitterStatusTextViewer.cs 25 2010-01-17 19:55:07Z catwalk $
*/
using System;
using System.Configuration;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;
using System.Web;
using Hiyoko.Net.Twitter;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class TwitterStatusTextViewer : UserControl{
		public TwitterStatusTextViewer(){
			this.InitializeComponent();
		}
		
		private static readonly Regex parseStatusTextRegex =
			new Regex(@"(?<url>[a-z]+:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)|@(?<user>[a-zA-Z0-9_]+)|(?<hash>#([a-zA-Z0-9_]+|[^ \t]+_))", RegexOptions.Compiled);
		private static void TextPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e){
			string text = HttpUtility.HtmlDecode((string)e.NewValue);
			TextBlock textBlock = ((TwitterStatusTextViewer)d).textBlock;
			textBlock.Inlines.Clear();
			if(!String.IsNullOrEmpty(text)){
				Match match = parseStatusTextRegex.Match(text);
				int right = 0;
				while(match.Success){
					textBlock.Inlines.Add(text.Substring(right, match.Index - right));
					Group group;
					if((group = match.Groups["url"]).Success){
						Hyperlink link = new Hyperlink();
						link.Tag = group.Value;
						link.Click += Hyperlink_Click;
						link.Inlines.Add(group.Value);
						textBlock.Inlines.Add(link);
					}else if((group = match.Groups["user"]).Success){
						Hyperlink link = new Hyperlink();
						link.Tag = "http://twitter.com/" + group.Value;
						link.Click += Hyperlink_Click;
						link.Inlines.Add(group.Value);
						textBlock.Inlines.Add("@");
						textBlock.Inlines.Add(link);
					}else if((group = match.Groups["hash"]).Success){
						Hyperlink link = new Hyperlink();
						link.Tag = "http://search.twitter.com/search?q=" + HttpUtility.UrlEncode(group.Value, Encoding.UTF8);
						link.Click += Hyperlink_Click;
						link.Inlines.Add(group.Value);
						textBlock.Inlines.Add(link);
					}
					
					right = match.Index + match.Length;
					match = match.NextMatch();
				}
				textBlock.Inlines.Add(text.Substring(right));
			}
		}
		
		private static void Hyperlink_Click(object sender, RoutedEventArgs e){
			try{
				Hyperlink link = (Hyperlink)sender;
				Process.Start((string)link.Tag);
			}catch(Exception ex){
				MessageBox.Show("オープンに失敗しました。\n\n" + ex.Message, "Hiyoko", MessageBoxButton.OK, MessageBoxImage.Error);
			}
		}
		
		#region プロパティ
		
		public static readonly DependencyProperty TextProperty =
			DependencyProperty.Register("Text", typeof(string), typeof(TwitterStatusTextViewer), new PropertyMetadata("", TextPropertyChanged));
		public string Text{
			get{
				return (string)this.GetValue(TextProperty);
			}
			set{
				this.SetValue(TextProperty, value);
			}
		}
		
		public static readonly DependencyProperty TextWrappingProperty =
			DependencyProperty.Register("TextWrapping", typeof(TextWrapping), typeof(TwitterStatusTextViewer), new PropertyMetadata(TextWrapping.Wrap));
		public TextWrapping TextWrapping{
			get{
				return (TextWrapping)this.GetValue(TextWrappingProperty);
			}
			set{
				this.SetValue(TextWrappingProperty, value);
			}
		}
		
		public static readonly DependencyProperty TextTrimmingProperty =
			DependencyProperty.Register("TextTrimming", typeof(TextTrimming), typeof(TwitterStatusTextViewer), new PropertyMetadata(TextTrimming.None));
		public TextTrimming TextTrimming{
			get{
				return (TextTrimming)this.GetValue(TextTrimmingProperty);
			}
			set{
				this.SetValue(TextTrimmingProperty, value);
			}
		}
		
		public static readonly DependencyProperty HyperlinkForegroundProperty =
			DependencyProperty.Register("HyperlinkForeground", typeof(Brush), typeof(TwitterStatusTextViewer), new PropertyMetadata(null));
		public Brush HyperlinkForeground{
			get{
				return (Brush)this.GetValue(HyperlinkForegroundProperty);
			}
			set{
				this.SetValue(HyperlinkForegroundProperty, value);
			}
		}
		
		#endregion
	}

}