<?php
	// Copyright (c) 2008, u6k.yu1@gmail.com
	// All rights reserved.
	// 
	// Redistribution and use in source and binary forms, with or without
	// modification, are permitted provided that the following conditions are met:
	//     * Redistributions of source code must retain the above copyright
	//       notice, this list of conditions and the following disclaimer.
	//     * Redistributions in binary form must reproduce the above copyright
	//       notice, this list of conditions and the following disclaimer in the
	//       documentation and/or other materials provided with the distribution.
	//     * Neither the name of the u6k nor the
	//       names of its contributors may be used to endorse or promote products
	//       derived from this software without specific prior written permission.
	// 
	// THIS SOFTWARE IS PROVIDED BY u6k.yu1@gmail.com ``AS IS'' AND ANY
	// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	// DISCLAIMED. IN NO EVENT SHALL u6k.yu1@gmail.com BE LIABLE FOR ANY
	// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	
	require_once("error.php");
	require_once("Hirameki_DateTimeUtil.php");
	
	/**
	 * HTMLに関連する機能を提供します。
	 * 
	 * @package common
	 * @author u6k <u6k.yu1@gmail.com>
	 * @copyright Copyright (c) 2008 u6k.yu1@gmail.com, All rights reserved.
	 * @license BSD License
	 * @version $Id$
	 * @link http://hirameki-note.sourceforge.jp/ ひらめきノート
	 */
	class Hirameki_HtmlUtil {
		/**
		 * HTTPヘッダにContent-Typeを出力します。
		 * 
		 * このメソッドは、HTTPリクエスト・ヘッダのHTTP_USER_AGENTを参照して、application/xhtml+xmlとtext/htmlのどちらかを出力します。
		 * 
		 * @param void
		 * @return void
		 */
		public static function headerContentType() {
			if (stripos($_SERVER["HTTP_USER_AGENT"], "MSIE") === FALSE) {
				header("Content-Type: application/xhtml+xml");
			} else {
				header("Content-Type: text/html; charset=UTF-8");
			}
		}
		
		/**
		 * 文字列を出力します。HTMLにおける特殊文字は実体参照に、改行は<br/>タグに置換されます。
		 * 
		 * @param string $text 出力する文字列。
		 * @return void
		 */
		public static function printStr($text) {
			if (!empty($text)) {
				print(nl2br(htmlspecialchars($text)));
			}
		}
		
		/**
		 * 数値を文字列として出力します。型チェックや変換などはしていません。
		 * 
		 * @param int $value 出力する数値。
		 * @return void
		 */
		public static function printInt($value) {
			if (!empty($value)) {
				print($value);
			}
		}
		
		/**
		 * 日時(を表す数値)を文字列として出力します。
		 * 
		 * @param int $time 出力する日時。
		 * @return void
		 */
		public static function printTime($time) {
			if (!empty($time)) {
				print(Hirameki_DateTimeUtil::format($time));
			}
		}
	}
?>
