/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.annotation.SuppressLint;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.OLYCameraStatusTrait;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.n;

public class OLYCameraPropertyTrait {
    private OLYCamera.h a;
    private static Map<String, Set<String>> b;
    private Set<String> c;
    private Set<String> d;
    private Set<String> e;
    private Set<String> f;
    private Map<String, String> g;
    private Map<String, List<String>> h;

    protected OLYCameraPropertyTrait(OLYCamera.h adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.h)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    private static void a() {
        b = n.f();
    }

    public void setupCameraProperty(Set<String> cameraPropertyNames, Set<String> readonlyCameraPropertyNames) {
        this.f = new HashSet<String>(){
            {
                this.add("TAKEMODE");
                this.add("TAKE_DRIVE");
                this.add("EXPOSE_MOVIE_SELECT");
                this.add("ISO");
                this.add("RECENTLY_ART_FILTER");
                this.add("TOUCH_EFFECTIVE_AREA_UPPER_LEFT");
                this.add("TOUCH_EFFECTIVE_AREA_LOWER_RIGHT");
                this.add("TOUCH_AE_EFFECTIVE_AREA_UPPER_LEFT");
                this.add("TOUCH_AE_EFFECTIVE_AREA_LOWER_RIGHT");
            }
        };
        this.h = new ConcurrentHashMap<String, List<String>>();
        this.g = new ConcurrentHashMap<String, String>();
        this.c = cameraPropertyNames;
        this.d = readonlyCameraPropertyNames;
        this.e = this.c;
    }

    public void teardownCameraProperty() {
        this.c = null;
        this.e = null;
        this.d = null;
        this.g = null;
        this.h = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheAll() {
        if (this.g != null) {
            for (String name : this.c) {
                if (n.g().contains(name)) continue;
                this.g.remove(name);
            }
        }
        if (this.h != null) {
            for (String name : this.c) {
                if (n.g().contains(name)) continue;
                Map<String, List<String>> map = this.h;
                synchronized (map) {
                    this.h.remove(name);
                }
            }
        }
    }

    public void clearValueCache(Set<String> propertyNames) {
        if (propertyNames == null) {
            return;
        }
        if (this.g != null) {
            for (String name : propertyNames) {
                this.g.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListCache(Set<String> propertyNames) {
        if (propertyNames == null) {
            return;
        }
        if (this.h != null) {
            for (String name : propertyNames) {
                Map<String, List<String>> map = this.h;
                synchronized (map) {
                    this.h.remove(name);
                }
            }
        }
    }

    public Set<String> getCameraPropertyNames() {
        return Collections.unmodifiableSet(this.c);
    }

    public List<String> getCameraPropertyValueList(final String name) throws OLYCameraKitException {
        Map<String, Object> cameraDescription;
        OLYCameraLog.i("name=%s", name);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.c.contains(name)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'name' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.h.containsKey(name)) {
            List<String> cachedList = this.h.get(name);
            return Collections.unmodifiableList(this.a(name, cachedList));
        }
        if (this.a.c() && name.equals("BLE_PSWD_ENABLE")) {
            cameraDescription = new HashMap<String, Object>(){
                {
                    this.put("enum", new ArrayList<String>(){
                        {
                            this.add("OFF");
                        }
                    });
                }
            };
        } else {
            try {
                cameraDescription = this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                    @Override
                    public Map<String, Object> a(h value) throws Exception {
                        return value.f(name, 10.0);
                    }
                });
            }
            catch (Exception e2) {
                OLYCameraKitException theException = new OLYCameraKitException(e2);
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        Object enumElement = cameraDescription.get("enum");
        if (enumElement != null) {
            ArrayList cameraValueList = (ArrayList)enumElement;
            for (String cameraValue : cameraValueList) {
                list.add(jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(name, cameraValue).c());
            }
        }
        this.h.put(name, list);
        return Collections.unmodifiableList(this.a(name, list));
    }

    public String getCameraPropertyValue(final String name) throws OLYCameraKitException {
        String cameraValue;
        OLYCameraLog.i("name=%s", name);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.c.contains(name)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'name' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (this.g.containsKey(name)) {
            String cachedValue = this.g.get(name);
            OLYCameraLog.i("name=%s, cached value=%s", name, cachedValue);
            return cachedValue;
        }
        HashSet<String> specialNames = new HashSet<String>(){
            {
                this.add("BLE_NAME");
                this.add("BLE_PSWD");
                this.add("BLE_PSWD_ENABLE");
            }
        };
        if (this.a.c() && specialNames.contains(name)) {
            try {
                if (name.equals("BLE_NAME")) {
                    cameraValue = this.a.b(new OLYCamera.c<String, jp.co.olympus.camerakit.a>(){

                        @Override
                        public String a(jp.co.olympus.camerakit.a value) throws Exception {
                            return value.Z(10.0);
                        }
                    });
                }
                if (name.equals("BLE_PSWD")) {
                    cameraValue = this.a.b(new OLYCamera.c<String, jp.co.olympus.camerakit.a>(){

                        @Override
                        public String a(jp.co.olympus.camerakit.a value) throws Exception {
                            return value.ab(10.0);
                        }
                    });
                }
                if (name.equals("BLE_PSWD_ENABLE")) {
                    cameraValue = this.a.b(new OLYCamera.c<String, jp.co.olympus.camerakit.a>(){

                        @Override
                        public String a(jp.co.olympus.camerakit.a value) throws Exception {
                            return value.ac(10.0);
                        }
                    });
                }
                throw new AssertionError();
            }
            catch (Exception e2) {
                OLYCameraKitException theException = new OLYCameraKitException(e2);
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
        } else {
            try {
                cameraValue = this.a.a(new OLYCamera.c<String, h>(){

                    @Override
                    public String a(h value) throws Exception {
                        return value.g(name, 10.0);
                    }
                });
            }
            catch (Exception e3) {
                OLYCameraKitException theException = new OLYCameraKitException(e3);
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
        }
        String value = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(name, cameraValue).c();
        if (this.f.contains(name)) {
            this.g.put(name, value);
        }
        OLYCameraLog.i("name=%s, value=%s", name, value);
        return value;
    }

    public Map<String, String> getCameraPropertyValues(final Set<String> names) throws OLYCameraKitException {
        Map<String, String> cameraValues;
        OLYCameraLog.i("names=%s", names);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (names == null || names.size() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'names' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        for (String name : names) {
            if (this.c.contains(name)) continue;
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'names' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            cameraValues = this.a.a(new OLYCamera.c<Map<String, String>, h>(){

                @Override
                public Map<String, String> a(h value) throws Exception {
                    return value.a(names, 10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashMap<String, String> treatedCameraValues = new HashMap<String, String>();
        for (String key : cameraValues.keySet()) {
            a propertyValue = new a(key, cameraValues.get(key));
            treatedCameraValues.put(key, propertyValue.c());
            if (!this.f.contains(key)) continue;
            this.g.put(key, propertyValue.c());
        }
        return treatedCameraValues;
    }

    public RectF getCameraPropertyValueAutoFocusEffectiveAreaRect() throws OLYCameraKitException {
        int point1_y;
        int point1_x;
        int point0_y;
        int point0_x;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.f()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        OLYCamera.LiveViewSize liveViewSize = this.a.g();
        if (liveViewSize == null || liveViewSize.getWidth() == 0 || liveViewSize.getHeight() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value of 'liveViewSize' property is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        String strPoint0 = this.getCameraPropertyValue("TOUCH_EFFECTIVE_AREA_UPPER_LEFT");
        if ((strPoint0 = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(strPoint0).b()) == null || strPoint0.length() != 8) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        String strPoint1 = this.getCameraPropertyValue("TOUCH_EFFECTIVE_AREA_LOWER_RIGHT");
        if ((strPoint1 = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(strPoint1).b()) == null || strPoint1.length() != 8) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point0_x = Integer.parseInt(strPoint0.substring(0, 4), 16);
        }
        catch (NumberFormatException e2) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point0_y = Integer.parseInt(strPoint0.substring(4, 8), 16);
        }
        catch (NumberFormatException e3) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point1_x = Integer.parseInt(strPoint1.substring(0, 4), 16);
        }
        catch (NumberFormatException e4) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point1_y = Integer.parseInt(strPoint1.substring(4, 8), 16);
        }
        catch (NumberFormatException e5) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        RectF rect = new RectF();
        rect.left = (float)point0_x / (float)liveViewSize.getWidth();
        rect.top = (float)point0_y / (float)liveViewSize.getHeight();
        rect.right = (float)point1_x / (float)liveViewSize.getWidth();
        rect.bottom = (float)point1_y / (float)liveViewSize.getHeight();
        return rect;
    }

    public RectF getCameraPropertyValueAutoExposureEffectiveAreaRect() throws OLYCameraKitException {
        int point1_y;
        int point1_x;
        int point0_y;
        int point0_x;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.f()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        OLYCamera.LiveViewSize liveViewSize = this.a.g();
        if (liveViewSize == null || liveViewSize.getWidth() == 0 || liveViewSize.getHeight() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value of 'liveViewSize' property is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        String strPoint0 = this.getCameraPropertyValue("TOUCH_AE_EFFECTIVE_AREA_UPPER_LEFT");
        if ((strPoint0 = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(strPoint0).b()) == null || strPoint0.length() != 8) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        String strPoint1 = this.getCameraPropertyValue("TOUCH_AE_EFFECTIVE_AREA_LOWER_RIGHT");
        if ((strPoint1 = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(strPoint1).b()) == null || strPoint1.length() != 8) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point0_x = Integer.parseInt(strPoint0.substring(0, 4), 16);
        }
        catch (NumberFormatException e2) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point0_y = Integer.parseInt(strPoint0.substring(4, 8), 16);
        }
        catch (NumberFormatException e3) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point1_x = Integer.parseInt(strPoint1.substring(0, 4), 16);
        }
        catch (NumberFormatException e4) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            point1_y = Integer.parseInt(strPoint1.substring(4, 8), 16);
        }
        catch (NumberFormatException e5) {
            OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        RectF rect = new RectF();
        rect.left = (float)point0_x / (float)liveViewSize.getWidth();
        rect.top = (float)point0_y / (float)liveViewSize.getHeight();
        rect.right = (float)point1_x / (float)liveViewSize.getWidth();
        rect.bottom = (float)point1_y / (float)liveViewSize.getHeight();
        return rect;
    }

    public boolean canSetCameraProperty(String name) {
        String lensMountStatus;
        OLYCameraLog.i("name=%s", name);
        if (!this.a.a()) {
            return false;
        }
        if (!this.a.d() && !this.a.e()) {
            return false;
        }
        if (!this.c.contains(name)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'name' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            return false;
        }
        if (this.d.contains(name)) {
            return false;
        }
        if (this.e != null && this.e.contains(name)) {
            return false;
        }
        return !name.equals("APERTURE") || (lensMountStatus = this.a.h().getLensMountStatus()) != null || lensMountStatus.startsWith("normal");
    }

    private boolean a(String name, String value) {
        OLYCameraLog.i("name=%s, value=%s", name, value);
        if (!this.a.a()) {
            return false;
        }
        a propertyValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(value);
        if (propertyValue == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            return false;
        }
        String decodedName = propertyValue.a();
        String decodedData = propertyValue.b();
        if (decodedName == null || !decodedName.equals(name)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            return false;
        }
        if (!this.canSetCameraProperty(decodedName)) {
            return false;
        }
        HashSet<String> specialNames = new HashSet<String>(){
            {
                this.add("SSID");
                this.add("WIFI_PSWD");
                this.add("BLE_NAME");
                this.add("BLE_PSWD");
            }
        };
        if (specialNames.contains(decodedName)) {
            if (decodedName.equals("BLE_NAME")) {
                if (decodedData.length() < 1 || decodedData.length() > 8) {
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    return false;
                }
            } else if (decodedName.equals("BLE_PSWD")) {
                Pattern pattern = Pattern.compile("^[0-9]{6}$");
                Matcher matcher = pattern.matcher(decodedData);
                if (!matcher.matches()) {
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    return false;
                }
            } else if (decodedData.length() == 0) {
                return false;
            }
        } else {
            List<String> list;
            try {
                list = this.getCameraPropertyValueList(decodedName);
            }
            catch (OLYCameraKitException e2) {
                return false;
            }
            if (!list.contains(value)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraPropertyValue(final String name, String value) throws OLYCameraKitException {
        block35: {
            a propertyValue;
            OLYCameraLog.i("name=%s, value=%s", name, value);
            if (!this.a.a()) {
                OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            if (!this.a.d() && !this.a.e()) {
                OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode or 'OLYCamera.RunMode#Maintenance' mode.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            if (!this.c.contains(name)) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'name' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            boolean valueIsValidated = false;
            if (name.equals("APERTURE")) {
                List<String> filteredList = null;
                List<String> originalList = null;
                Map<String, List<String>> map = this.h;
                synchronized (map) {
                    try {
                        filteredList = this.getCameraPropertyValueList("APERTURE");
                    }
                    catch (OLYCameraKitException e2) {
                        // empty catch block
                    }
                    originalList = this.h.get("APERTURE");
                }
                if (filteredList == null || originalList == null) {
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    throw theException;
                }
                if (filteredList.size() > 0 && originalList.size() > 0) {
                    boolean containedFilteredList = filteredList.contains(value);
                    boolean containedOriginalList = originalList.contains(value);
                    if (containedFilteredList && containedOriginalList) {
                        valueIsValidated = true;
                    } else if (containedFilteredList && !containedOriginalList) {
                        String adjustedValue;
                        int index;
                        String secondItem;
                        if (filteredList.get(0).equals(value)) {
                            secondItem = filteredList.get(0);
                            if (filteredList.size() > 1) {
                                secondItem = filteredList.get(1);
                            }
                            if ((index = originalList.indexOf(secondItem)) > 0) {
                                --index;
                            }
                            adjustedValue = originalList.get(index);
                            OLYCameraLog.d("The value for parameter 'value' has been overwritten to %s.", adjustedValue);
                            value = adjustedValue;
                            valueIsValidated = true;
                        } else if (filteredList.get(filteredList.size() - 1).equals(value)) {
                            secondItem = filteredList.get(filteredList.size() - 1);
                            if (filteredList.size() > 1) {
                                secondItem = filteredList.get(filteredList.size() - 2);
                            }
                            if ((index = originalList.indexOf(secondItem)) < originalList.size() - 1) {
                                ++index;
                            }
                            adjustedValue = originalList.get(index);
                            OLYCameraLog.d("The value for parameter 'value' has been overwritten to %s.", adjustedValue);
                            value = adjustedValue;
                            valueIsValidated = true;
                        }
                    }
                }
            }
            if ((propertyValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(value)) == null) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            String decodedName = propertyValue.a();
            String decodedData = propertyValue.b();
            if (decodedName == null || !decodedName.equals(name)) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'value' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            if (!valueIsValidated && !this.a(name, value)) {
                OLYCameraKitException theException = new OLYCameraKitException("Changing the value of the property is not permitted.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            try {
                String fDecodedData;
                HashSet<String> specialNames = new HashSet<String>(){
                    {
                        this.add("BLE_NAME");
                        this.add("BLE_PSWD");
                        this.add("BLE_PSWD_ENABLE");
                    }
                };
                if (this.a.c() && specialNames.contains(decodedName)) {
                    fDecodedData = decodedData;
                    try {
                        if (name.equals("BLE_NAME")) {
                            this.a.b(new OLYCamera.c<Void, jp.co.olympus.camerakit.a>(){

                                @Override
                                public Void a(jp.co.olympus.camerakit.a value) throws Exception {
                                    value.k(fDecodedData, 10.0);
                                    return null;
                                }
                            });
                            break block35;
                        }
                        if (name.equals("BLE_PSWD")) {
                            this.a.b(new OLYCamera.c<Void, jp.co.olympus.camerakit.a>(){

                                @Override
                                public Void a(jp.co.olympus.camerakit.a value) throws Exception {
                                    value.a(fDecodedData, true, 10.0);
                                    return null;
                                }
                            });
                            break block35;
                        }
                        if (name.equals("BLE_PSWD_ENABLE")) {
                            if (decodedData.equals("ON")) {
                                OLYCameraKitException theException = new OLYCameraKitException("Changing the value of the property is not permitted.");
                                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                                throw theException;
                            }
                            if (decodedData.equals("OFF")) {
                                this.a.b(new OLYCamera.c<Void, jp.co.olympus.camerakit.a>(){

                                    @Override
                                    public Void a(jp.co.olympus.camerakit.a value) throws Exception {
                                        value.aa(10.0);
                                        return null;
                                    }
                                });
                            }
                            break block35;
                        }
                        throw new AssertionError();
                    }
                    catch (Exception e3) {
                        OLYCameraKitException theException = new OLYCameraKitException(e3);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        throw theException;
                    }
                }
                fDecodedData = decodedData;
                this.a.a(new OLYCamera.c<Void, h>(){

                    @Override
                    public Void a(h value) throws Exception {
                        value.b(name, fDecodedData, 10.0);
                        return null;
                    }
                });
            }
            catch (Exception e4) {
                OLYCameraKitException theException = new OLYCameraKitException(e4);
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
        }
        this.b(name, value);
        if ("<TAKEMODE/movie>".equals(value) && !this.a.g().equals(OLYCamera.LiveViewSize.VGA)) {
            OLYCameraLog.w("The size of live-view should be VGA if the camera property TAKEMODE set to movie.", new Object[0]);
        }
    }

    public void setCameraPropertyValues(Map<String, String> values) throws OLYCameraKitException {
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d() && !this.a.e()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode or 'OLYCamera.RunMode#Maintenance' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (values == null || values.size() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'values' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashSet<String> readonlyCameraPropertyNames = n.c();
        for (String string : values.keySet()) {
            if (!this.c.contains(string)) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'values' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            if (!readonlyCameraPropertyNames.contains(string)) continue;
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'values' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        HashMap<String, String> decodedValues = new HashMap<String, String>();
        for (String name : values.keySet()) {
            a propertyValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(values.get(name));
            if (propertyValue == null) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'values' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            String decodedName = propertyValue.a();
            String decodedData = propertyValue.b();
            if (decodedName == null || !decodedName.equals(name)) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'values' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                throw theException;
            }
            decodedValues.put(name, decodedData);
        }
        boolean bl = values.containsKey("RECENTLY_ART_FILTER");
        boolean containsExposeMovieSelect = values.containsKey("EXPOSE_MOVIE_SELECT");
        boolean containsTakemode = values.containsKey("TAKEMODE");
        if (bl && !containsTakemode || containsExposeMovieSelect && !containsTakemode) {
            String takemode = this.getCameraPropertyValue("TAKEMODE");
            a takemodeValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(takemode);
            decodedValues.put("TAKEMODE", takemodeValue.b());
        }
        ArrayList<String> prefferedProperties = new ArrayList<String>(){
            private static final long b = 6591497360450862054L;
            {
                this.add("RECENTLY_ART_FILTER");
                this.add("EXPOSE_MOVIE_SELECT");
                this.add("TAKEMODE");
                this.add("COLORTONE");
                this.add("RAW");
                this.add("DESTINATION_FILE");
            }
        };
        final LinkedHashMap decodedList = new LinkedHashMap();
        for (String propname : prefferedProperties) {
            if (!decodedValues.containsKey(propname)) continue;
            decodedList.put(propname, decodedValues.get(propname));
            decodedValues.remove(propname);
        }
        for (String key : decodedValues.keySet()) {
            decodedList.put(key, decodedValues.get(key));
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.a(decodedList, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            for (String name : values.keySet()) {
                if (n.g().contains(name)) continue;
                this.g.remove(name);
                this.h.remove(name);
            }
            try {
                this.updateInactiveCameraPropertyNames();
            }
            catch (OLYCameraKitException e1) {
                // empty catch block
            }
            throw theException;
        }
        for (String name : values.keySet()) {
            if (!name.equals("TAKEMODE") && !name.equals("EXPOSE_MOVIE_SELECT")) {
                this.g.remove(name);
            }
            if (n.g().contains(name)) continue;
            this.h.remove(name);
        }
        for (String name : values.keySet()) {
            if (!this.f.contains(name)) continue;
            this.g.put(name, values.get(name));
        }
        try {
            this.updateInactiveCameraPropertyNames();
        }
        catch (OLYCameraKitException e3) {
            // empty catch block
        }
        String value = this.g.get("TAKEMODE");
        if ("<TAKEMODE/movie>".equals(value) && !this.a.g().equals(OLYCamera.LiveViewSize.VGA)) {
            OLYCameraLog.w("The size of live-view should be VGA if the camera property TAKEMODE set to movie.", new Object[0]);
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private List<String> a(String name, List<String> list) {
        OLYCameraStatusTrait cameraStatus = this.a.h();
        if (name.equals("SHUTTER")) {
            if (!this.a.f()) {
                OLYCameraLog.w("The current list has all values. The list is filtered exactly by starting a live view.", new Object[0]);
                return list;
            }
            ArrayList<String> filteredList = new ArrayList<String>();
            double minimumNumber = cameraStatus.getMinimumShutterSpeed();
            double maximumNumber = cameraStatus.getMaximumShutterSpeed();
            if (Double.isNaN(minimumNumber) || Double.isNaN(maximumNumber)) {
                OLYCameraLog.w("The current list is empty. The list is filtered exactly by attaching a lens.", new Object[0]);
                return filteredList;
            }
            for (String value : list) {
                String data = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(value).b();
                double number = 0.0;
                if (data.endsWith("\"")) {
                    number = Float.parseFloat(data.substring(0, data.length() - 1));
                } else {
                    number = Float.parseFloat(data);
                    if (number != 0.0) {
                        number = 1.0 / number;
                    }
                }
                if (!(number > 0.0) || number < minimumNumber || number > maximumNumber) continue;
                filteredList.add(value);
            }
            return filteredList;
        }
        if (name.equals("APERTURE")) {
            String maximumData;
            String maximumValue;
            String minimumData;
            String minimumValue;
            if (!this.a.f()) {
                OLYCameraLog.w("The current list has all values. The list is filtered exactly by starting a live view.", new Object[0]);
                return list;
            }
            ArrayList<String> filteredList = new ArrayList<String>();
            double minimumNumber = cameraStatus.getMinimumApertureValue();
            double maximumNumber = cameraStatus.getMaximumApertureValue();
            if (Double.isNaN(minimumNumber) || Double.isNaN(maximumNumber)) {
                OLYCameraLog.w("The current list is empty. The list is filtered exactly by attaching a lens.", new Object[0]);
                return filteredList;
            }
            for (String value : list) {
                String data = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(value).b();
                double number = Float.parseFloat(data);
                if (!(number > 0.0) || number < minimumNumber || number > maximumNumber) continue;
                filteredList.add(value);
            }
            if (filteredList.size() > 0 && !filteredList.contains(minimumValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(name, minimumData = minimumNumber < 10.0 ? String.format("%1.1f", minimumNumber) : String.format("%1.0f", minimumNumber)).c())) {
                filteredList.add(0, minimumValue);
            }
            if (filteredList.size() > 0 && !filteredList.contains(maximumValue = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(name, maximumData = maximumNumber < 10.0 ? String.format("%1.1f", maximumNumber) : String.format("%1.0f", maximumNumber)).c())) {
                filteredList.add(maximumValue);
            }
            return filteredList;
        }
        if (name.equals("EXPREV")) {
            if (!this.a.f()) {
                OLYCameraLog.w("The current list has all values. The list is filtered exactly by starting a live view.", new Object[0]);
                return list;
            }
            ArrayList<String> filteredList = new ArrayList<String>();
            double minimumNumber = cameraStatus.getMinimumExposureCompensation();
            double maximumNumber = cameraStatus.getMaximumExposureCompensation();
            if (Double.isNaN(minimumNumber) || Double.isNaN(maximumNumber)) {
                OLYCameraLog.w("The current list is empty. The list is filtered exactly by attaching a lens.", new Object[0]);
                return filteredList;
            }
            for (String value : list) {
                String data = jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a(value).b();
                double number = Float.parseFloat(data);
                if (number < minimumNumber || number > maximumNumber) continue;
                filteredList.add(value);
            }
            return filteredList;
        }
        HashSet<String> inactiveCameraPropertyValues = n.e();
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String value : list) {
            if (inactiveCameraPropertyValues.contains(value)) continue;
            filteredList.add(value);
        }
        return filteredList;
    }

    private void b(String name, String value) {
        if (name.equals("TAKEMODE") || name.equals("EXPOSE_MOVIE_SELECT")) {
            String inactiveNamesKey = null;
            if (name.equals("TAKEMODE")) {
                if (value.equals(jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a("TAKEMODE", "movie").c())) {
                    try {
                        inactiveNamesKey = this.getCameraPropertyValue("EXPOSE_MOVIE_SELECT");
                    }
                    catch (OLYCameraKitException e2) {}
                } else {
                    inactiveNamesKey = value;
                }
            } else {
                try {
                    String takemode = this.getCameraPropertyValue("TAKEMODE");
                    inactiveNamesKey = takemode.equals(jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a("TAKEMODE", "movie").c()) ? value : takemode;
                }
                catch (OLYCameraKitException e3) {
                    // empty catch block
                }
            }
            this.e = inactiveNamesKey != null ? b.get(inactiveNamesKey) : null;
            if (this.e == null) {
                OLYCameraLog.w("Could not update the inactive property name list.", new Object[0]);
            }
        }
        if (this.f.contains(name)) {
            this.g.put(name, value);
        }
        if (Arrays.asList("TAKEMODE", "COLORTONE", "RECENTLY_ART_FILTER", "EXPOSE_MOVIE_SELECT", "ASPECT_RATIO").contains(name)) {
            for (String item : this.c) {
                if (!item.equals(name)) {
                    this.g.remove(item);
                }
                if (n.g().contains(item)) continue;
                this.h.remove(item);
            }
        } else if ("SHUTTER".equals(name)) {
            this.h.remove("ISO");
        }
    }

    public void updateInactiveCameraPropertyNames() throws OLYCameraKitException {
        String exposeMovieSelect;
        String takemode;
        try {
            takemode = this.getCameraPropertyValue("TAKEMODE");
        }
        catch (OLYCameraKitException e2) {
            throw new OLYCameraKitException(e2);
        }
        try {
            exposeMovieSelect = this.getCameraPropertyValue("EXPOSE_MOVIE_SELECT");
        }
        catch (OLYCameraKitException e3) {
            throw new OLYCameraKitException(e3);
        }
        String inactiveNamesKey = null;
        inactiveNamesKey = takemode.equals(jp.co.olympus.camerakit.OLYCameraPropertyTrait$a.a("TAKEMODE", "movie").c()) ? exposeMovieSelect : takemode;
        this.e = inactiveNamesKey != null ? b.get(inactiveNamesKey) : null;
        if (this.e == null) {
            OLYCameraLog.w("Could not update the inactive property name list.", new Object[0]);
        }
    }

    static {
        OLYCameraPropertyTrait.a();
    }

    protected static final class a {
        private String a;
        private String b;

        public String a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }

        private a(String name, String data) {
            if (name == null) {
                throw new IllegalArgumentException("name could not be null.");
            }
            if (data == null) {
                throw new IllegalArgumentException("data could not be null.");
            }
            this.a = name;
            this.b = data;
        }

        public static a a(String name, String data) {
            return new a(name, data);
        }

        public static a a(String value) {
            if (value == null) {
                return null;
            }
            Pattern pattern = Pattern.compile("^<([^/]+)/([^/]+)>$");
            Matcher matcher = pattern.matcher(value);
            if (!matcher.find()) {
                return null;
            }
            String decodedName = matcher.group(1);
            String decodedData = matcher.group(2);
            return new a(decodedName, decodedData);
        }

        public String c() {
            return String.format("<%s/%s>", this.a(), this.b());
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                a rhs = (a)o2;
                return this.a().equals(rhs.a()) && this.b().equals(rhs.b());
            }
            return false;
        }

        public int hashCode() {
            return (this.a() + this.b()).hashCode();
        }
    }
}

