<?php
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Model.class.php');
/**
 * ログイン用ビジネスモデルクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_Exists extends system_login_Model {
	function system_login_Exists(){
	}
	function execute( & $request ) {
		$isExists			= true;
		$isRegistable		= false;
		$loginId			= $request->getParam('login_id');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if ( strlen( $loginId ) < 1 ) {
			$request->addError('system.error.login.user.requireloginid'
			,'',array(),false,SPIDER_LOG_LEVEL_ERROR);
		}
		if( !$request->isError() ) {
			$userObject = system_login_User::getUserObjectByLoginId($request, $loginId);
			if( $userObject !== false ){
				$isExists	= true;
				if( get_class($loginUserObject) == get_class($userObject) ){
					if($loginUserObject->getUniqueId() == $userObject->getUniqueId() ){
						$isRegistable	= true;
					} else {
						$isRegistable	= false;
					}
				} else {
					$isRegistable		= false;
				}
			} else {
				$isExists	= false;
			}
		} else {
			$isExists			= true;
			$isRegistable		= false;
		}
		$request->setAttribute('system.login.isExistsLoginId',$isExists);
		$request->setAttribute('system.login.isRegistableLoginId',$isRegistable);
	}
	
	
	/**
	 * 全てのユーザー定義クラスの取得
	 */
	function getUserClassName( $request ) {
		return system_PackageConfig::loadAllUserClassFile( $request );
	}
}
?>