#buttonedit
require 'vr/vrcontrol'
require 'vr/vrowndraw'
require 'vr/vrhandler'
require "#{File.dirname(__FILE__)}/drawframes"

class ButtonEdit < VREdit
  include VRDestroySensitive
  
  alias org_caption  caption
  alias org_caption= caption=
  
  def caption() @bt.caption if @bt; end
  def caption=(txt) return super unless @bt; @bt.caption = txt; end
  
  def text()   self.org_caption; end
  def text=(s) self.org_caption = s; end
  
  def button_w() @bt.w; end
  
  def self_destroy() parent.deleteControl(@bt); end
end

class ButtonEditL < ButtonEdit
  class BuddyButton < VRButton
    BS_OWNERDRAW = 0x0000000B
    WINCLASSINFO = ["BUTTON", BS_OWNERDRAW]
    include DrawFrames
    
    def ownerdraw(iid,action,state,hwnd,hdc,left,top,right,bottom,data)
      GC.disable
      self.opaque = false
      drawEdge(left, top, right, bottom, BDR_SUNKENINNER | BDR_SUNKENOUTER,
                                        BF_TOP | BF_LEFT | BF_BOTTOM | BF_RIGHT)
      if (pushed = ((state & 1)>0) ) # drawpushed
        drawFrameControl(left+2, top+2, right, bottom-2,
                                      DFC_BUTTON, DFCS_BUTTONPUSH | DFCS_PUSHED)
        drawText(self.caption,left+2,top+4,right-2,bottom-2,caption.size,1)
      else # drawreleased
        drawFrameControl(left+2,top+2,right,bottom-2,DFC_BUTTON,DFCS_BUTTONPUSH)
        drawText(caption,left,top+2,right-2,bottom-2,caption.size,1)
      end
      GC.enable
    end
    
    def setbuddy(win)
      @buddy = win
      self.caption = win.org_caption
      win.org_caption = ''
      _x,_y,_w,_h = win.windowrect
      move(win.x, win.y, self.w, win.h)
      win.move(win.x,win.y,_w-self.w,_h)
    end
  end
  
  def vrinit
    super
    @bt = parent.addControl BuddyButton,name+'_button', '', x-16,y, 16, h
    @bt.setbuddy(self)
  end
  
    
  def button_w=(width)
    return unless @bt
    _x,_y,_w, _h = windowrect
    @bt.move(@bt.x, @bt.y, width, @bt.h)
    org_move(@bt.x+width-2, y, _w-width, _h)
    width
  end
  
  def windowrect
    x, y, w, h = super
    [x-@bt.w+2, y, w + @bt.w, h]
  end
    
  alias org_move move
  def move(x, y, w, h)
    if @bt
      @bt.move(x, y, @bt.w, h)
      org_move(x+@bt.w-2, y, w-@bt.w, h) 
    else
      org_move(x, y, w, h)
    end
  end
end

class ButtonEditR < ButtonEdit
  class BuddyButton < VRButton
    BS_OWNERDRAW = 0x0000000B
    WINCLASSINFO = ["BUTTON", BS_OWNERDRAW]
    include DrawFrames
    def ownerdraw(iid,action,state,hwnd,hdc,left,top,right,bottom,data)
      GC.disable
      self.opaque = false
      drawEdge(left, top, right, bottom, BDR_SUNKENINNER | BDR_SUNKENOUTER,
                                                  BF_TOP | BF_RIGHT | BF_BOTTOM)
      if (pushed = ((state & 1)>0) ) # drawpushed
        drawFrameControl(left, top+2, right-2, bottom-2, DFC_BUTTON,
                                                  DFCS_BUTTONPUSH | DFCS_PUSHED)
        drawText(self.caption, left+2, top+4, right-2, bottom-2, caption.size, 1)
      else # drawreleased
        drawFrameControl(left, top+2, right-2, bottom-2,
                                                    DFC_BUTTON,DFCS_BUTTONPUSH)
        drawText(caption, left, top+2, right-2, bottom-2, caption.size, 1)
      end
      GC.enable
    end
    
    def setbuddy(win)
      @buddy = win
      self.caption = win.org_caption
      win.org_caption = ''
      move(win.x+win.w, win.y, self.w, win.h)
      _x,_y,_w,_h = win.windowrect
      win.move(win.x,win.y,_w-self.w,_h)
    end
  end
  
  def vrinit
    @bt = parent.addControl BuddyButton,name+'_bdybtn', '', x-16,y, 16, h
    @bt.setbuddy(self)
    super
  end
  
  def button_w=(width)
    return unless @bt
    _x,_y,_w,_h = windowrect
    org_move(x,y,_w-width,_h)
    @bt.move(self.x+_w-width-2, y, width, self.h)
    width
  end
  
  def windowrect
    x, y, w, h = super
    [x, y, w + @bt.w, h]
  end
  
  alias org_move move
  def move(x, y, w, h)
    if @bt
      org_move(x, y, w-@bt.w, h) 
      @bt.move(x+w-@bt.w, y, @bt.w, h)
    else
      org_move(x, y, w, h)
    end
  end
end

if  $0 == __FILE__
  require 'vr/vruby'
  require 'vr/vrcomctl'

  class Form1 < VRForm
    def construct
      self.caption = 'form1'
      self.move(140,124,500,400)
      addControl ButtonEditL, 'bte1', 'a', 20, 10, 100, 22
      addControl ButtonEditR, 'bte2', 'a', 20, 40, 100, 22
      @bte1.button_w = 40
      @bte2.button_w = 40
    end 
  end
  
  VRLocalScreen.start Form1
end
