/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: BlockRowRepeatParamParser.java 163 2010-08-05 05:49:12Z akira-yokoi $
 * $Revision: 163 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.util.ReportsUtil;

/**
 * w肳ꂽ͈͂cɌJԂĒup[T
 * 
 * @since 1.0
 */
public class BlockRowRepeatParamParser extends ReportsTagParser<Object[]> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( BlockRowRepeatParamParser.class);

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$BR[]";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * ͈fromp[^
     */
    public static final String PARAM_FROM_CELL = "fromCell";

    /**
     * ͈top[^
     */
    public static final String PARAM_TO_CELL = "toCell";

    /**
     * JԂ񐔃p[^
     */
    public static final String PARAM_REPEAT_NUM = "repeatNum";

    /**
     * ܂Ԃ񐔃p[^
     */
    public static final String PARAM_TURN_NUM = "turnNum";

    /**
     * d\p[^
     */
    public static final String PARAM_DUPLICATE = "hideDuplicate";

    /**
     * ^Op[^
     */
    public static final String PARAM_REMOVE_TAG = "removeTag";

    /**
     * RXgN^
     */
    public BlockRowRepeatParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public BlockRowRepeatParamParser( String tag) {
        super( tag);
    }

    @Override
    public boolean useControlRow() {
        return true;
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {
        try {
            // p[^̎擾
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // p[^`FbN
            checkParam( sheet, paramDef, tagCell);

            ReportsParserInfo reportsParserInfo = ( ReportsParserInfo) data;
            ParamInfo paramInfo = reportsParserInfo.getParamInfo();

            // parseʃIuWFNg
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            List<Object> resultList = new ArrayList<Object>();

            // ubNuŏIW
            int finalBlockRowIndex = 0;
            int finalBlockColIndex = 0;

            String brTagName = paramDef.get( PARAM_VALUE);
            if ( log.isDebugEnabled()) {
                log.debug( "BRp[^: " + brTagName);
            }

            // p[^ɑΉf[^擾
            Object[] paramInfos = getParamData( paramInfo, brTagName);
            if ( paramInfos == null) {
                return parsedReportInfo;
            }

            // Pũp[T[擾
            List<SingleParamParser> singleParsers = getSingleReplaceParsers( reportsParserInfo);

            // POJOParamInfoɕϊ
            List<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
            for ( Object obj : paramInfos) {
                if ( obj instanceof ParamInfo) {
                    paramInfoList.add( ( ParamInfo) obj);
                    continue;
                }
                ParamInfo childParamInfo = new ParamInfo();
                @SuppressWarnings( "unchecked")
                Map<String, Object> map = PropertyUtils.describe( obj);
                for ( Map.Entry<String, Object> entry : map.entrySet()) {
                    for ( ReportsTagParser<?> parser : singleParsers) {
                        childParamInfo.addParam( parser.getTag(), entry.getKey(), entry.getValue());
                    }
                }
                paramInfoList.add( childParamInfo);
            }
            paramInfos = paramInfoList.toArray( new ParamInfo[paramInfoList.size()]);

            // repeatNum`
            Integer repeatNum = paramInfos.length;
            if ( paramDef.containsKey( PARAM_REPEAT_NUM)) {
                if ( Integer.valueOf( paramDef.get( PARAM_REPEAT_NUM)) < repeatNum) {
                    repeatNum = Integer.valueOf( paramDef.get( PARAM_REPEAT_NUM));
                }
            }

            // duplicateParams`  Pu^O`ƂăGĝ݂ǉ
            Map<String, Object> unduplicableParamMap = new HashMap<String, Object>();
            if ( paramDef.containsKey( PARAM_DUPLICATE)) {
                String[] params = paramDef.get( PARAM_DUPLICATE).split( ";");
                for ( String param : params) {
                    for ( ReportsTagParser<?> parser : singleParsers) {
                        param = parser.getTag() + TAG_PARAM_PREFIX + param + TAG_PARAM_SUFFIX;
                        unduplicableParamMap.put( param, "");
                    }
                }
            }

            // removeTag`
            boolean removeTag = false;
            if ( paramDef.containsKey( PARAM_REMOVE_TAG)) {
                removeTag = Boolean.valueOf( paramDef.get( PARAM_REMOVE_TAG));
            }

            // ^OZW
            int tagCellRowIndex = tagCell.getRowIndex();
            int tagCellColIndex = tagCell.getColumnIndex();

            // fromCell`
            String fromCellParamDef = paramDef.get( PARAM_FROM_CELL);
            int[] fromCellPosition = ReportsUtil.getCellIndex( fromCellParamDef, PARAM_FROM_CELL);
            int defaultFromCellRowIndex = tagCellRowIndex + fromCellPosition[0];
            int defaultFromCellColIndex = tagCellColIndex + fromCellPosition[1];

            // toCell`
            String toCellParamDef = paramDef.get( PARAM_TO_CELL);
            int[] toCellPosition = ReportsUtil.getCellIndex( toCellParamDef, PARAM_TO_CELL);
            int defaultToCellRowIndex = tagCellRowIndex + toCellPosition[0];
            int defaultToCellColIndex = tagCellColIndex + toCellPosition[1];

            // ZlEZX^C`
            Object[][] blockCellValues = ReportsUtil.getBlockCellValue( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            CellStyle[][] blockCellStyles = ReportsUtil.getBlockCellStyle( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int[][] blockCellTypes = ReportsUtil.getBlockCellType( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            float[] rowHeight = ReportsUtil.getRowHeight( sheet, defaultFromCellRowIndex, defaultToCellRowIndex);

            // ΏۃV[g茋Z擾
            CellRangeAddress[] margedCells = ReportsUtil.getMargedCells( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);

            // ubNTCY擾
            final int defaultBlockHeight = defaultToCellRowIndex - defaultFromCellRowIndex + 1;
            final int defaultBlockWidth = defaultToCellColIndex - defaultFromCellColIndex + 1;
            int rowlen = defaultBlockHeight;
            int collen = defaultBlockWidth;

            // ͈ʒu(fromCell`ʒuJn, 1ubN͌Ɉʒu̕␳s)
            int blockStartRowIndex = defaultFromCellRowIndex;
            int blockStartColIndex = defaultFromCellColIndex;
            int blockEndRowIndex = defaultToCellRowIndex;
            int blockEndColIndex = defaultToCellColIndex;
            int maxblockEndRowIndex = blockEndRowIndex;

            parsedReportInfo.setDefaultRowIndex( defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex( defaultToCellColIndex);

            for ( int repeatCount = 0; repeatCount < repeatNum; repeatCount++) {
                // Qڈȍ~̓ubN`͈͂̃Z}s
                if ( repeatCount > 0) {
                    blockStartRowIndex = blockEndRowIndex + 1;
                    blockEndRowIndex = blockStartRowIndex + rowlen - 1;

                    CellRangeAddress rangeAddress = new CellRangeAddress( blockStartRowIndex, blockEndRowIndex, blockStartColIndex, PoiUtil.getLastColNum( sheet));
                    PoiUtil.insertRangeDown( sheet, rangeAddress);

                    if ( log.isDebugEnabled()) {
                        log.debug( "ev[g}");
                        log.debug( "}͈ : " + blockStartRowIndex + ":" + (blockStartRowIndex + rowlen - 1) + ":" + blockStartColIndex + ":" + PoiUtil.getLastColNum( sheet));
                    }

                    // Z̐ݒ
                    // ҏWV[g̓A^CōXVĂ߁A
                    // Z̎wɂ͓I␳s
                    int targetRowNum = maxblockEndRowIndex - (defaultFromCellRowIndex - 1);
                    for ( CellRangeAddress address : margedCells) {
                        // JnsZJns + BR^OݏύŏIs - BR^O݈ʒu
                        // IsZIs + BR^OݏύŏIs - BR^O݈ʒu
                        // Jn񁁌ZJn(BR^O͍sɓWJ邽ߓI␳sv)
                        // I񁁌ZI(BR^O͍sɓWJ邽ߓI␳sv)
                        int firstRowNum = address.getFirstRow() + targetRowNum;
                        int lastRowNum = address.getLastRow() + targetRowNum;
                        int firstColumnNum = address.getFirstColumn();
                        int lastColumnNum = address.getLastColumn();

                        CellRangeAddress copyAddress = new CellRangeAddress( firstRowNum, lastRowNum, firstColumnNum, lastColumnNum);
                        sheet.addMergedRegion( copyAddress);
                    }

                }

                if ( log.isDebugEnabled()) {
                    log.debug( "repeatCount = " + repeatCount);
                    log.debug( "blockStartRowIndex = " + blockStartRowIndex);
                    log.debug( "blockStartColIndex = " + blockStartColIndex);
                }

                // ubN͈͂̒lEX^CKp
                if ( log.isDebugEnabled()) {
                    log.debug( "ubNRs[ f[^[v=" + repeatCount);
                }

                for ( int rowIdx = 0; rowIdx < defaultBlockHeight; rowIdx++) {
                    // s擾
                    Row row = sheet.getRow( blockStartRowIndex + rowIdx);
                    // Rs[̍snullARs[̍sɉ炩̏Ăꍇ͍s𐶐
                    if ( row == null && !ReportsUtil.isEmptyRow( blockCellTypes[rowIdx], blockCellValues[rowIdx], blockCellStyles[rowIdx])) {
                        row = sheet.createRow( blockStartRowIndex + rowIdx);
                    }

                    if ( row != null) {
                        // s̍̐ݒ
                        row.setHeightInPoints( rowHeight[rowIdx]);

                        // Z擾ݒ
                        for ( int colIdx = 0; colIdx < defaultBlockWidth; colIdx++) {
                            // Z擾
                            Cell cell = row.getCell( blockStartColIndex + colIdx);
                            // Z^Cv̎擾
                            int cellType = blockCellTypes[rowIdx][colIdx];
                            // Zl̎擾
                            Object cellValue = blockCellValues[rowIdx][colIdx];
                            // ZX^C̎擾
                            CellStyle cellStyle = blockCellStyles[rowIdx][colIdx];
                            // Zɐݒ肷ׂi^CvAlAX^ĈꂩjLꍇ̂ݐ
                            if ( cell == null && !ReportsUtil.isEmptyCell( cellType, cellValue, cellStyle)) {
                                cell = row.createCell( blockStartColIndex + colIdx);
                            }

                            // Zݒ
                            if ( cell != null) {
                                // Z^Cv̐ݒ
                                cell.setCellType( cellType);
                                // Z̒l̐ݒ
                                PoiUtil.setCellValue( cell, cellValue);
                                // Z̃X^C̐ݒ
                                if ( cellStyle == null) {
                                    log.info( "Cell Style at [" + rowIdx + "," + colIdx + "] is not available. Skipping setCellValue()");
                                } else {
                                    cell.setCellStyle( cellStyle);
                                }
                                log.debug( "row=" + (blockStartRowIndex + rowIdx) + " col" + (blockStartColIndex + colIdx) + ">>>>>>" + blockCellValues[rowIdx][colIdx]);
                            }
                        }
                    }
                }

                int currentBlockHeight = rowlen;
                int currentBlockWidth = collen;
                // qp[Tł̍s}ɂĐe^O͔͈͂̑̒l
                int plusRowNum = 0;
                // qp[Tł̍s}ɂĐe^O͔͈͂̑̒l
                int plusColNum = 0;
                collen = defaultBlockWidth;
                // s[v
                // ubN͈͂̒l̉
                for ( int targetRow = blockStartRowIndex; targetRow < blockStartRowIndex + rowlen + plusRowNum; targetRow++) {
                    if ( finalBlockRowIndex < targetRow) {
                        finalBlockRowIndex = targetRow;
                    }
                    if ( sheet.getRow( targetRow) == null) {
                        if ( log.isDebugEnabled()) {
                            log.debug( "row=" + targetRow + " : row is not available. continued...");
                        }
                        continue;
                    }

                    for ( int targetCol = blockStartColIndex; targetCol <= blockStartColIndex + collen + plusColNum - 1; targetCol++) {
                        if ( finalBlockColIndex < targetCol) {
                            finalBlockColIndex = targetCol;
                        }
                        Cell targetCell = sheet.getRow( targetRow).getCell( targetCol);
                        if ( targetCell == null) {
                            if ( log.isDebugEnabled()) {
                                log.debug( "row=" + targetRow + " col=" + targetCol + " : cell is not available. continued...");
                            }
                            continue;
                        }

                        // ^Op[T̎擾
                        TagParser<?> parser = reportsParserInfo.getMatchTagParser( sheet, targetCell);
                        if ( parser == null) {
                            if ( log.isDebugEnabled()) {
                                log.debug( "row=" + targetRow + " col=" + targetCol + " parser is not available. continued...");
                            }
                            continue;
                        }

                        String targetCellTag = targetCell.getStringCellValue();
                        if ( log.isDebugEnabled()) {
                            log.debug( "########## ^OZW row=" + targetRow + " col=" + targetCol + " ^O=" + targetCellTag + " ##########");
                        }

                        // p[Xs
                        ParsedReportInfo result = ( ParsedReportInfo) parser.parse( sheet, targetCell, reportsParserInfo.createChildParserInfo( ( ParamInfo) paramInfos[repeatCount]));
                        resultList.add( result.getParsedObject());

                        // qp[Tł̍s}
                        plusRowNum += result.getRowIndex() - result.getDefaultRowIndex();

                        // qp[Tł̗}
                        plusColNum += result.getColumnIndex() - result.getDefaultColumnIndex();

                        int additionalHeight = result.getRowIndex() - result.getDefaultRowIndex();
                        int additionalWidth = result.getColumnIndex() - result.getDefaultColumnIndex();

                        // qp[T󂯎ŏIW͔͈͂̕␳
                        currentBlockHeight = currentBlockHeight + additionalHeight;
                        currentBlockWidth = currentBlockWidth + additionalWidth;

                        // ds
                        if ( parser instanceof SingleParamParser) {
                            if ( unduplicableParamMap.containsKey( targetCellTag)) {
                                if ( unduplicableParamMap.get( targetCellTag).equals( result.getParsedObject())) {
                                    PoiUtil.setCellValue( targetCell, "");

                                } else {
                                    unduplicableParamMap.put( targetCellTag, result.getParsedObject());
                                }
                            }
                        }

                        // qp[TɂďcɑAqp[T̃^OʒuO̗ɃZ}
                        if ( defaultFromCellColIndex != result.getDefaultColumnIndex() && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress preRangeAddress = new CellRangeAddress( blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), blockStartColIndex,
                                targetCol - 1);
                            PoiUtil.insertRangeDown( sheet, preRangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***c␳***");
                                log.debug( "}͈1 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + blockStartColIndex + ":"
                                        + (targetCol - 1));
                            }
                        }

                        // Ȑꍇ̓^Oʒuȍ~ɂZ}
                        if ( parser instanceof RowRepeatParamParser && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress rearRangeAddress = new CellRangeAddress( blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), result
                                .getDefaultColumnIndex() + 1, PoiUtil.getLastColNum( sheet));
                            PoiUtil.insertRangeDown( sheet, rearRangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***c␳***");
                                log.debug( "}͈2 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":"
                                        + (result.getDefaultColumnIndex() + 1) + ":" + PoiUtil.getLastColNum( sheet));
                            }
                        }

                        blockEndRowIndex += result.getRowIndex() - result.getDefaultRowIndex();

                        if ( parser instanceof BlockColRepeatParamParser || parser instanceof BlockRowRepeatParamParser) {
                            collen += result.getColumnIndex() - result.getDefaultColumnIndex();
                            plusColNum -= result.getColumnIndex() - result.getDefaultColumnIndex();
                        }

                        // q̃p[XĉɑAubNŏIWXV
                        if ( blockStartColIndex + collen + plusColNum - 1 > blockEndColIndex) {
                            int beforeLastColIndex = blockEndColIndex;
                            blockEndColIndex = blockStartColIndex + collen + plusColNum - 1;

                            // ^OZs猻ݍŝP܂łɉɑZ}
                            CellRangeAddress preRangeAddress = new CellRangeAddress( tagCell.getRowIndex(), targetRow - 1, beforeLastColIndex + 1, blockEndColIndex);
                            PoiUtil.insertRangeRight( sheet, preRangeAddress);

                            if ( log.isDebugEnabled()) {
                                log.debug( "***␳***");
                                log.debug( "}͈1 : " + tagCell.getRowIndex() + ":" + (targetRow - 1) + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex);
                            }
                        }

                        // 񃋁[vI
                    }
                    // sɉɑZ}
                    if ( blockStartColIndex + collen + plusColNum - 1 < blockEndColIndex) {
                        CellRangeAddress rearRangeAddress = new CellRangeAddress( targetRow, targetRow, blockStartColIndex + collen + plusColNum, blockEndColIndex);
                        PoiUtil.insertRangeRight( sheet, rearRangeAddress);

                        if ( log.isDebugEnabled()) {
                            log.debug( "***␳***");
                            log.debug( "}͈2 : " + targetRow + ":" + targetRow + ":" + (blockStartColIndex + collen + plusColNum) + ":" + blockEndColIndex);
                        }
                    }
                    plusColNum = 0;

                    // s[vI
                }
                // ubNŏIȍ~ɏcɐLт̃Z}
                CellRangeAddress rearRangeAddress = new CellRangeAddress( maxblockEndRowIndex + 1, blockEndRowIndex, blockEndColIndex + 1, PoiUtil.getLastColNum( sheet));
                PoiUtil.insertRangeDown( sheet, rearRangeAddress);
                if ( log.isDebugEnabled()) {
                    log.debug( "}͈2 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + (blockEndColIndex + 1) + ":" + PoiUtil.getLastColNum( sheet));
                }

                maxblockEndRowIndex = blockEndRowIndex;
            }

            // ^O
            if ( removeTag) {
                tagCell.setCellType( Cell.CELL_TYPE_BLANK);
            }

            // ͌
            parsedReportInfo.setColumnIndex( finalBlockColIndex);
            parsedReportInfo.setRowIndex( finalBlockRowIndex);
            parsedReportInfo.setParsedObject( resultList);
            parsedReportInfo.setDefaultRowIndex( defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex( defaultToCellColIndex);

            if ( log.isDebugEnabled()) {
                log.debug( "finalBlockRowIndex= " + finalBlockRowIndex);
                log.debug( "finalBlockColIndex=" + finalBlockColIndex);
            }

            return parsedReportInfo;

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }

    }

    /**
     * ݎgpĂPup[T[擾B
     * 
     * @param reportsParserInfo [͏
     * @return ݎgpĂPu
     */
    private List<SingleParamParser> getSingleReplaceParsers( ReportsParserInfo reportsParserInfo) {
        List<ReportsTagParser<?>> parsers = reportsParserInfo.getReportParsers();
        List<SingleParamParser> singleParsers = new ArrayList<SingleParamParser>();
        for ( ReportsTagParser<?> reportsParser : parsers) {
            if ( reportsParser instanceof SingleParamParser) {
                singleParsers.add( ( SingleParamParser) reportsParser);
            }
        }
        return singleParsers;
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef
     * @param tagCell
     * @throws ParseException
     */
    private void checkParam( Sheet sheet, Map<String, String> paramDef, Cell tagCell) throws ParseException {

        // K{IvV`FbN
        // fromCell
        if ( !paramDef.containsKey( PARAM_FROM_CELL)) {
            throw new ParseException( tagCell, "K{p[^ȂF" + PARAM_FROM_CELL);
        }
        // toCell
        if ( !paramDef.containsKey( PARAM_TO_CELL)) {
            throw new ParseException( tagCell, "K{p[^ȂF" + PARAM_TO_CELL);
        }

        // l
        if ( paramDef.get( PARAM_FROM_CELL).split( ":").length != 2) {
            throw new ParseException( tagCell + "p[^lsF" + PARAM_FROM_CELL);
        }
        if ( paramDef.get( PARAM_TO_CELL).split( ":").length != 2) {
            throw new ParseException( tagCell + "p[^lsF" + PARAM_TO_CELL);
        }

        // lÓ`FbN
        // ͈fromA͈to
        int[] fromCellIndex = ReportsUtil.getCellIndex( paramDef.get( PARAM_FROM_CELL), PARAM_FROM_CELL);
        int[] toCellIndex = ReportsUtil.getCellIndex( paramDef.get( PARAM_TO_CELL), PARAM_TO_CELL);
        // }CiX`FbN
        if ( fromCellIndex[0] < 0 || fromCellIndex[1] < 0) {
            throw new ParseException( tagCell, "p[^lsF" + PARAM_FROM_CELL);
        }
        if ( toCellIndex[0] < 0 || toCellIndex[1] < 0) {
            throw new ParseException( tagCell, "p[^lsF" + PARAM_TO_CELL);
        }
        // s͈͎w`FbN
        if ( fromCellIndex[0] > toCellIndex[0]) {
            throw new ParseException( tagCell, "p[^sisjF" + PARAM_FROM_CELL + "," + PARAM_TO_CELL);
        }
        // ͈͎w`FbN
        if ( fromCellIndex[1] > toCellIndex[1]) {
            throw new ParseException( tagCell, "p[^sijF" + PARAM_FROM_CELL + "," + PARAM_TO_CELL);
        }

        // JԂ񐔃`FbNilj
        if ( paramDef.containsKey( PARAM_REPEAT_NUM)) {
            try {
                if ( Integer.valueOf( paramDef.get( PARAM_REPEAT_NUM)) < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_REPEAT_NUM);
                }
            } catch ( NumberFormatException e) {
                throw new ParseException( tagCell + "p[^sF" + PARAM_REPEAT_NUM);
            }
        }
    }
}
