/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportSheet.java 136 2010-07-29 04:29:25Z akira-yokoi $
 * $Revision: 136 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.model;

import java.io.Serializable;
import java.util.Map;

/**
 * [NV[g̒uێNX
 * 
 * @since 1.0
 */
@SuppressWarnings("serial")
public class ReportSheet implements Serializable{

    /**
     * ev[gV[g
     */
    private String templateName = null;

    /**
     * o̓V[g
     */
    private String sheetName = null;

    /**
     * p[^
     */
    private ParamInfo paramInfo = new ParamInfo();

    /**
     * ftHgRXgN^
     */
    public ReportSheet() {
    }

    /**
     * RXgN^<BR>
     * ev[go̓V[g̏ꍇ
     * @param templateName ev[gV[g
     * @param sheetName o̓V[g
     */
    public ReportSheet( String templateName, String sheetName) {
        this.templateName = templateName;
        this.sheetName = sheetName;
    }
    
    /**
     * RXgN^<BR>
     * ev[gV[g̏ꍇ
     * @param sheetName V[g
     */
    public ReportSheet( String sheetName) {
        this.templateName = sheetName;
        this.sheetName = sheetName;
    }

    /**
     * ev[gV[g擾܂B
     * 
     * @return ev[gV[g
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * o̓V[g擾܂B
     * 
     * @return o̓V[g
     */
    public String getSheetName() {
        return sheetName;
    }

    /**
     * o̓V[gݒ肵܂B
     * 
     * @param sheetName o̓V[g
     */
    public void setSheetName( String sheetName) {
        this.sheetName = sheetName;
    }

    /**
     * ev[gV[gݒ肵܂B
     * 
     * @param templateName ev[gV[g
     */
    public void setTemplateName( String templateName) {
        this.templateName = templateName;
    }

    /**
     * up[^擾
     * @return up[^@
     */
    public ParamInfo getParamInfo() {
        return paramInfo;
    }

    /**
     * p[^̒ǉ
     * 
     * @param tag ^O
     * @param paramName p[^
     * @param data f[^
     * @see org.bbreak.excella.reports.model.ParamInfo#addParam(java.lang.String, java.lang.String, java.lang.Object)
     */
    public void addParam( String tag, String paramName, Object data) {
        paramInfo.addParam( tag, paramName, data);
    }

    /**
     * p[^̒ǉ
     * 
     * @param tag ^O
     * @param params ǉp[^
     * @see org.bbreak.excella.reports.model.ParamInfo#addParams(java.lang.String, java.util.Map)
     */
    public void addParams( String tag, Map<String, Object> params) {
        paramInfo.addParams( tag, params);
    }

    /**
     * p[^̃NA
     * @see org.bbreak.excella.reports.model.ParamInfo#clearParam()
     */
    public void clearParam() {
        paramInfo.clearParam();
    }

    /**
     * p[^̃NA
     * 
     * @param tag ^O
     * @see org.bbreak.excella.reports.model.ParamInfo#clearParam(java.lang.String)
     */
    public void clearParam( String tag) {
        paramInfo.clearParam( tag);
    }

    /**
     * p[^̃f[^擾
     * 
     * @param tag ^O
     * @param paramName p[^
     * @return p[^ɑΉf[^B݂Ȃꍇnull
     * @see org.bbreak.excella.reports.model.ParamInfo#getParam(java.lang.String, java.lang.String)
     */
    public Object getParam( String tag, String paramName) {
        return paramInfo.getParam( tag, paramName);
    }

    /**
     * p[^̍폜
     * 
     * @param tag ^O
     * @param paramName p[^
     * @see org.bbreak.excella.reports.model.ParamInfo#removeParam(java.lang.String, java.lang.String)
     */
    public void removeParam( String tag, String paramName) {
        paramInfo.removeParam( tag, paramName);
    }

}
