/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: RemoveAdapter.java 90 2009-11-20 02:01:10Z akira-yokoi $
 * $Revision: 90 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.listener;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.tag.RemoveParamParser;
import org.bbreak.excella.reports.tag.ReportsTagParser;

/**
 * V[g͌ɃZEEsEs폜A_v^
 * 
 * @since 1.0
 */
public class RemoveAdapter extends ReportProcessAdaptor {

    /**
     * s
     */
    public static final String ROW = "row";

    /**
     * 
     */
    public static final String COLUMN = "column";

    /**
     * Z
     */
    public static final String CELL = "cell";

    /**
     * ɃVtgiftHgj
     */
    public static final String LEFT = "left";

    /**
     * ɃVtg
     */
    public static final String UP = "up";

    /*
     * (non-Javadoc)
     * 
     * @see org.bbreak.excella.reports.listener.ReportProcessAdaptor#postParse(org.apache.poi.ss.usermodel.Sheet, org.bbreak.excella.core.SheetParser, org.bbreak.excella.core.SheetData)
     */
    @Override
    public void postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {

        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();

        for ( int rowIndex = firstRowNum; rowIndex <= lastRowNum; rowIndex++) {

            Row row = sheet.getRow( rowIndex);
            if ( row != null) {
                int firstColNum = row.getFirstCellNum();
                int lastColNum = row.getLastCellNum() - 1;
                boolean isRowFlag = false;

                for ( int colIndex = firstColNum; colIndex <= lastColNum; colIndex++) {
                    Cell cell = row.getCell( colIndex);
                    if ( cell != null) {
                        if ( cell.getCellType() == Cell.CELL_TYPE_STRING && cell.getStringCellValue().contains( RemoveParamParser.DEFAULT_TAG)) {
                            // ^Õp[^擾
                            String[] paramArray = getStrParam( sheet, rowIndex, colIndex);

                            // 폜PʁiZEEsj
                            String removeUnit = paramArray[0];
                            // ^OZ폜
                            row.removeCell( cell);

                            // sS̍폜̏ꍇ̏
                            if ( removeUnit.equals( "") || removeUnit.equals( ROW)) {
                                removeControlRow( sheet, rowIndex);
                                isRowFlag = true;
                                break;
                            } else if ( removeUnit.equals( CELL) || removeUnit.equals( COLUMN)) {
                                // Z܂͗S̍폜̏ꍇ̏
                                removeCellOrCol( paramArray, removeUnit, sheet, row, cell, rowIndex, colIndex);
                            }
                            lastColNum = row.getLastCellNum() - 1;
                            colIndex--;
                        }
                        // s̏
                        if ( isControlRow( sheet, sheetParser, row, cell)) {
                            removeControlRow( sheet, rowIndex);
                            isRowFlag = true;
                            break;
                        }
                    }
                }
                // s폜ꍇ
                if ( isRowFlag) {
                    lastRowNum = sheet.getLastRowNum();
                    rowIndex--;
                }
            }
        }
    }

    /**
     * REMOVE^Õp[^擾
     * 
     * @param sheet
     * @param rowIndex
     * @param colIndex
     * @return paramArray
     */
    private String[] getStrParam( Sheet sheet, int rowIndex, int colIndex) throws ParseException {
        Row row = sheet.getRow( rowIndex);
        Cell cell = row.getCell( colIndex);
        String strValue = cell.getStringCellValue();

        // ^Õp[^擾
        String param = TagUtil.getParam( strValue);
        String[] paramArray = param.split( TagParser.PARAM_DELIM);

        return paramArray;
    }

    /**
     * Z̍폜A܂͗̍폜s
     * 
     * @param paramArray
     * @param removeUnit
     * @param sheet
     * @param row
     * @param cell
     * @param rowIndex
     * @param colIndex
     * @return paramArray
     */
    private void removeCellOrCol( String[] paramArray, String removeUnit, Sheet sheet, Row row, Cell cell, int rowIndex, int colIndex) {
        if ( removeUnit.equals( CELL)) {
            if ( paramArray.length > 1) {
                // Z폜̃Vtg
                String direction = paramArray[1];
                if ( direction.equals( LEFT)) {
                    shiftLeft( row, cell, colIndex);
                } else if ( direction.equals( UP)) {
                    shiftUp( sheet, cell, rowIndex, colIndex);
                }
            } else {
                // ړ̎w肪Ȃ͍ɃVtg
                shiftLeft( row, cell, colIndex);
            }
        } else if ( removeUnit.equals( COLUMN)) {
            // S̍폜̏
            for ( int rowNum = 0; rowNum <= sheet.getLastRowNum(); rowNum++) {
                Row removeCol = sheet.getRow( rowNum);
                if ( removeCol != null) {
                    Cell removeCell = removeCol.getCell( colIndex);
                    if ( removeCell != null) {
                        removeCol.removeCell( removeCell);
                    }
                }
                shiftLeft( sheet.getRow( rowNum), cell, colIndex);
            }
        }
    }

    /**
     * Z폜ɔZɓiftHgj
     * 
     * @param row
     * @param cell
     * @param colIndex
     */
    private void shiftLeft( Row row, Cell cell, int colIndex) {
        // Rs[E\t
        int startCopyIndex = colIndex + 1;
        if ( row == null) {
            return;
        }
        int finishCopyIndex = row.getLastCellNum() - 1;

        for ( int copyColNum = startCopyIndex; copyColNum <= finishCopyIndex; copyColNum++) {
            // Rs[Z
            Cell fromCell = row.getCell( copyColNum);
            // Rs[Z
            Cell toCell = row.getCell( copyColNum - 1);

            if ( fromCell != null) {
                if ( toCell == null) {
                    toCell = row.createCell( copyColNum - 1);
                }
                PoiUtil.copyCell( fromCell, toCell);
                row.removeCell( fromCell);
            }
        }
    }

    /**
     * Z폜ɔZɓ
     * 
     * @param sheet
     * @param cell
     * @param rowIndex
     * @param colIndex
     */
    private void shiftUp( Sheet sheet, Cell cell, int rowIndex, int colIndex) {
        // Rs[JnEIsԍ
        int startCopyIndex = rowIndex + 1;
        int finishCopyIndex = sheet.getLastRowNum();

        for ( int copyRowNum = startCopyIndex; copyRowNum <= finishCopyIndex; copyRowNum++) {

            Row row = sheet.getRow( copyRowNum);
            if ( row != null) {
                Row preRow = sheet.getRow( copyRowNum - 1);
                // Rs[Z
                Cell fromCell = row.getCell( colIndex);

                if ( fromCell != null) {
                    // Rs[Z
                    Cell toCell = null;
                    if ( preRow == null) {
                        preRow = sheet.createRow( copyRowNum - 1);
                    }
                    toCell = preRow.getCell( colIndex);
                    if ( toCell == null) {
                        toCell = preRow.createCell( colIndex);
                    }
                    PoiUtil.copyCell( fromCell, toCell);
                    row.removeCell( fromCell);
                }
            }
        }
    }

    /**
     * s폜
     * 
     * @param sheet
     * @param rowIndex
     */
    private void removeControlRow( Sheet sheet, int rowIndex) {

        // ŏIsA폜
        if ( rowIndex == sheet.getLastRowNum()) {
            sheet.removeRow( sheet.getRow( rowIndex));
        } else {
            sheet.removeRow( sheet.getRow( rowIndex));
            sheet.shiftRows( rowIndex + 1, sheet.getLastRowNum(), -1, true, true);
        }
    }

    /**
     * s̗LԂB
     * 
     * @param sheet
     * @param sheetParser
     * @param row
     * @return
     */
    private boolean isControlRow( Sheet sheet, SheetParser sheetParser, Row row, Cell cell) {

        List<TagParser<?>> parsers = sheetParser.getTagParsers();

        for ( TagParser<?> parser : parsers) {
            try {
                if ( parser.isParse( sheet, cell)) {
                    if ( parser instanceof ReportsTagParser) {
                        ReportsTagParser<?> reportsTagParser = ( ReportsTagParser<?>) parser;
                        if ( reportsTagParser.useControlRow()) {
                            return true;
                        }
                    }
                }
            } catch ( ParseException e) {
                // ͂łȂ͈̂Ȃ
                continue;
            }
        }
        return false;
    }
}
