/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportBookExporter.java 14 2009-06-24 02:28:00Z tomo-shibata $
 * $Revision: 14 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.exporter;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.model.ConvertConfiguration;

/**
 * ͌(ubN)𒠕[o͂NX w肳ꂽpX(filePath)ɏo͂܂B
 * 
 * @since 1.0
 */
public abstract class ReportBookExporter implements BookExporter {

    /**
     * ϊݒ
     */
    private ConvertConfiguration configuration = null;

    /**
     * o͐t@CpX
     */
    private String filePath = null;

    /**
     * o͐t@CpX̎擾
     * 
     * @return o͐t@CpX
     */
    public String getFilePath() {
        return filePath;
    }

    /**
     * o͐t@CpX̐ݒ
     * 
     * @param filePath o͐t@CpX
     */
    public void setFilePath( String filePath) {
        this.filePath = filePath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.excelparser.exporter.book.BookExporter#export(org.apache.poi.ss.usermodel.Workbook, org.excelparser.BookData)
     */
    public void export( Workbook book, BookData bookdata) throws ExportException {
        // ev[g폜(bΉ)
        SortedSet<Integer> deleteSheetIndexs = new TreeSet<Integer>( Collections.reverseOrder());
        for ( int i = 0; i < book.getNumberOfSheets(); i++) {
            String sheetName = book.getSheetName( i);
            if ( sheetName.startsWith( PoiUtil.TMP_SHEET_NAME)) {
                deleteSheetIndexs.add( i);
            }
        }
        for ( int index : deleteSheetIndexs) {
            book.removeSheetAt( index);
        }

        if ( configuration != null) {
            // o
            output( book, bookdata, configuration);
        }

    }

    /**
     * o͂B
     * 
     * @param book [NubN
     * @param bookdata [NubN͏
     * @param configuration ϊݒ
     * @throws ExportException o͂Ɏsꍇ
     */
    public abstract void output( Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException;

    /**
     * ϊ^Cv擾B
     * 
     * @return ϊ^Cv
     */
    public abstract String getFormatType();
    
    /**
     * gq擾B
     * 
     * @return gq
     */
    public abstract String getExtention();
    

    /**
     * ϊݒݒ肷B
     * 
     * @param configuration ϊݒ
     */
    public void setConfiguration( ConvertConfiguration configuration) {
        this.configuration = configuration;
    }

    /* (non-Javadoc)
     * @see org.bbreak.excella.core.exporter.book.BookExporter#setup()
     */
    public void setup() {
    }

    /* (non-Javadoc)
     * @see org.bbreak.excella.core.exporter.book.BookExporter#tearDown()
     */
    public void tearDown() {
    }


}
