/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.parser;

import kry.sql.format.rule.AbstractSqlFormatRule;
import kry.sql.format.rule.ISqlFormatRule;
import kry.sql.token.ITokenSubType;
import kry.sql.token.ITokenType;
import kry.sql.token.Paren;
import kry.sql.token.Token;
import kry.sql.token.TokenList;
import kry.sql.token.TokenUtil;
import kry.sql.util.StringUtil;

/**
 *
 * @author kry
 *
 */
public class SqlParser {

	// p[Xx
	public static final int PARSE_LEVEL_1_TOKENIZE = 1;
	public static final int PARSE_LEVEL_2_OPTIMIZE = 2;
	public static final int PARSE_LEVEL_3_ANALYZE = 3;
	// public static final int PARSE_LEVEL_4_VALIDATE = 4;

	// XLi[
	private SqlScanner scanner;

	// g[NXg
	private TokenList tokenList;

	// tH[}bg[
	private AbstractSqlFormatRule rule;

	/**
	 * RXgN^
	 *
	 * @param rule
	 */
	public SqlParser(ISqlFormatRule rule) {
		this.rule = (AbstractSqlFormatRule) rule;
	}

	/**
	 * p[X
	 *
	 * @param sql
	 * @return
	 */
	public TokenList parse(String sql) {
		return parse(sql, PARSE_LEVEL_3_ANALYZE);
	}

	/**
	 * p[X
	 *
	 * @param sql
	 * @param parseLevel
	 * @return
	 */
	public synchronized TokenList parse(String sql, int parseLevel) {
		this.tokenList = new TokenList();

		tokenize(sql); // g[N

		optimize(parseLevel); // œK

		if (parseLevel >= PARSE_LEVEL_3_ANALYZE)
			analyzeParenRC(0, null); // ͏

		return this.tokenList;
	}

	/**
	 * g[N
	 *
	 * @param sql
	 */
	private void tokenize(String sql) {
		this.scanner = new SqlScanner(sql); // XLi

		// SQLJng[N
		Token token = new Token("", 0, 0, 0);
		token.setType(ITokenType.BEGIN_SQL);
		tokenList.add(token);

		int x = 0;
		int y = 0;
		int beforeType = ITokenType.UNKNOWN;
		int depthParen = 0;
		StringBuffer sb = new StringBuffer();

		for (; scanner.hasNext();) {
			int skipCount = scanner.skipSpaceTab();
			if (!scanner.hasNext())
				return;

			x += skipCount; // XWvZ
			int incY = 0; // YW
			int index = scanner.getCurrent(); // 擪̈ʒu
			int type = ITokenType.UNKNOWN;
			int subType = 0;
			sb.delete(0, sb.length());
			char c = scanner.peek();

			if (c == '\"') { // "XXXXX"
				// 
				do {
					sb.append(scanner.next());
					c = scanner.peek();
				} while (c != '\"' && scanner.hasNext());

				if (scanner.hasNext())
					sb.append(scanner.next());
				type = ITokenType.NAME;

			} else if (c == '\'') { // 'XXXXX'
				// l
				sb.append(scanner.next());
				c = scanner.peek();

				do {
					if (scanner.isPeekEquals("''")) {
						sb.append(scanner.next());
						sb.append(scanner.next());
						c = scanner.peek();

					} else if (c == '\'' && scanner.peek(1) != '\'') {
						break;

					} else {
						sb.append(scanner.next());
						c = scanner.peek();
					}

				} while ((c != '\'' && scanner.hasNext())
						|| (scanner.isPeekEquals("''")));

				if (scanner.hasNext())
					sb.append(scanner.next());
				type = ITokenType.VALUE;
				subType = ITokenSubType.VALUE_STRING;

			} else if (scanner.isPeekNextEquals(rule.getSingleLineComments(),
					sb)) {
				// RgFVOC

				do {
					sb.append(scanner.next());
					c = scanner.peek();
				} while (scanner.hasNext()
						&& !scanner.isPeekEquals(TokenUtil.NEW_LINES));

				type = ITokenType.COMMENT;
				subType = ITokenSubType.COMMENT_SINGLE_LINE;

			} else if (scanner.isPeekEquals("/*")) {
				// RgF}`C
				sb.append(scanner.next());
				c = scanner.peek();

				do {
					sb.append(scanner.next());
					c = scanner.peek();

					if (scanner.isPeekEquals(TokenUtil.NEW_LINES)) {
						if (scanner.isPeekEquals("\r\n")) {
							sb.append(scanner.next());
						}
						incY++;
					}

				} while (!scanner.isPeekEquals("*/") && scanner.hasNext());
				if (scanner.hasNext()) {
					sb.append(scanner.next());
					sb.append(scanner.next());
				}
				type = ITokenType.COMMENT;
				subType = ITokenSubType.COMMENT_MULTI_LINE;

			} else if (scanner.isPeekEquals(TokenUtil.NEW_LINES)) {
				// sH
				if (beforeType == ITokenType.NEW_LINE
						|| beforeType == ITokenType.EMPTY_LINE) {
					type = ITokenType.EMPTY_LINE;
				} else {
					type = ITokenType.NEW_LINE;
				}
				index = scanner.getCurrent() - skipCount;

				// s
				if (scanner.isPeekEquals("\r\n")) {
					sb.append(scanner.next());
				}
				sb.append(scanner.next());
				incY++; // YW

			} else if (Character.isDigit(c)) {
				// l ~[0-9].*|^[+-.][0-9].*
				do {
					sb.append(c);
					scanner.next();
					c = scanner.peek();
				} while (TokenUtil.isNumberChar(c));
				type = ITokenType.VALUE;
				subType = ITokenSubType.VALUE_NUMERIC;

			} else if (this.rule.isOperatorChars(c)) {
				// Zq
				String str = scanner.getPeekNextEqualsExString(this.rule
						.getOperators());

				if (str != null) {
					sb.append(str);
					if ("(".equals(str)) {
						depthParen++;
					}

				} else {
					// isȁjZq
					sb.append(scanner.next());
				}
				type = ITokenType.OPERATOR;

			} else if (TokenUtil.isBindVariable(c)
					&& !scanner.isPeekEqualsEx("::")) {
				// oChϐ
				sb.append(scanner.next());
				type = ITokenType.VALUE;
				subType = ITokenSubType.VALUE_BIND;

			} else if (rule.isSymbolChars(c)) {
				// L
				String str = scanner.getPeekNextEqualsExString(rule
						.getSymbols());

				if (str != null) {
					sb.append(str);
					if ("(".equals(str)) {
						depthParen++;
					}

				} else {
					// isȁjL
					sb.append(scanner.next());
				}

				type = ITokenType.SYMBOL;

			} else if (TokenUtil.isSqlSeparate(c)) {
				sb.append(scanner.next());
				type = ITokenType.SQL_SEPARATE;

			} else if (rule.isNameChar(c)) {
				// L[[hA
				do {
					sb.append(c);
					scanner.next();
					c = scanner.peek();
				} while (this.rule.isNameChar(c) && c != -1);

				String upper = sb.toString().toUpperCase();
				if (rule.isKeywords(upper)) {
					if (TokenUtil.isSpecialValue(upper)) {
						type = ITokenType.VALUE; // NULL,SYSDATE͒l
					} else {
						type = ITokenType.KEYWORD;
					}

				} else {
					type = ITokenType.NAME;
				}

			} else {
				// s
				sb.append(scanner.next());
			}

			// g[N
			String original = scanner.substring(index);
			token = new Token(original, x, y, index);

			switch (type) {
			case ITokenType.KEYWORD:
				token.setCustom(sb.toString());

				// Tu^Cvݒ
				if (rule.isSqlStartStatements(token.getUpper())) {
					subType = ITokenSubType.KEYWORD_SQL_STATEMENT;

				} else if (rule.isDataTypes(token.getUpper())) {
					subType = ITokenSubType.KEYWORD_DATATYPE;

				} else if (rule.isFunctions(token.getUpper())) {
					subType = ITokenSubType.KEYWORD_FUNCTION;

				} else {
					subType = ITokenSubType.KEYWORD_RESERVED_WORD;
				}
				break;

			case ITokenType.NEW_LINE:
			case ITokenType.EMPTY_LINE:
				token.setCustom(StringUtil.leftTrim(token.getOriginal(),
						TokenUtil.WORD_SEPARATE));
				x = 0;
				break;

			default:
				token.setCustom(sb.toString());
				break;
			}

			token.setType(type);
			token.setSubType(subType);
			// token.setDepthParen(depthParen);

			// g[NXgɒǉ
			this.tokenList.add(token);

			// ̃g[N̂߂̏
			beforeType = type; // g[NL

			// X,YWvZ
			x += original.length();
			y += incY;

			if (")".equals(sb.toString())) {
				depthParen--;
			}
		}

		// SQLIg[N
		token = new Token("", x, y, scanner.getLength());
		token.setType(ITokenType.END_SQL);
		tokenList.add(token);
	}

	/**
	 * œK܂B
	 *
	 * @param parseLevel
	 */
	private void optimize(int parseLevel) {
		StringBuffer sb = new StringBuffer();
		boolean optimize = (parseLevel >= PARSE_LEVEL_2_OPTIMIZE);

		for (int i = 0; i < tokenList.size(); i++) {
			Token current = tokenList.getToken(i);
			if (current == null)
				continue;

			int next1TokenIndex = tokenList.getNextValidTokenIndex(i, 1);
			Token next1 = tokenList.getToken(next1TokenIndex);
			if (next1 == null)
				continue;

			if (sb.length() != 0)
				sb.delete(0, sb.length()); // NA

			int currentType = current.getType();
			int currentSubType = current.getSubType();
			String currentUpper = current.getUpper();
			int next1Type = next1.getType();
			int next1SubType = next1.getSubType();
			String next1Upper = next1.getUpper();

			/**
			 * ^CvC
			 */
			if (currentType == ITokenType.OPERATOR && "/".equals(currentUpper)) {
				// wZq[/] [SQL,SQLI]  SQL؂蕶[/]x
				int next1TokenIndex2 = tokenList.getNextValidTokenIndex2(i, 1);
				Token next1_2 = tokenList.getToken(next1TokenIndex2);
				if (next1_2 != null
						&& (next1_2.getSubType() == ITokenSubType.KEYWORD_SQL_STATEMENT || next1_2
								.getType() == ITokenType.END_SQL)) {
					current.setType(ITokenType.SQL_SEPARATE);
					continue;
				}

			}

			/**
			 * g[NA
			 */
			if (currentType == ITokenType.SYMBOL && ".".equals(currentUpper)
					&& next1SubType == ITokenSubType.VALUE_NUMERIC) {
				// w. lxˁw.lx
				current.setType(ITokenType.VALUE);
				current.setSubType(ITokenSubType.VALUE_NUMERIC);
				current.setOriginal(scanner.getSql().substring(
						current.getIndex(),
						next1.getIndex() + next1.getOriginal().length()));
				sb.append('.').append(next1.getCustom());
				current.setCustom(sb.toString());
				tokenList.removeToken(i + 1, next1TokenIndex);
				i -= 3;
				continue;

			} else if (currentSubType == ITokenSubType.VALUE_BIND
					&& ":".equals(currentUpper)
					&& (next1Type == ITokenType.NAME || next1SubType == ITokenSubType.VALUE_NUMERIC)) {
				// w: [,l]xˁw:oChϐx
				current.setOriginal(scanner.getSql().substring(
						current.getIndex(),
						next1.getIndex() + next1.getOriginal().length()));
				sb.append(':').append(next1.getCustom());
				current.setCustom(sb.toString());
				tokenList.removeToken(i + 1, next1TokenIndex);
				i--;
				continue;

			} else if (currentType == ITokenType.NAME
					&& next1SubType == ITokenSubType.VALUE_STRING
					&& currentUpper.length() <= 2
					&& ("N".equals(currentUpper) || "Q".equals(currentUpper) || "NQ"
							.equals(currentUpper))) {
				// w[N,Q] ''xˁw[N,Q] ''x
				current.setType(ITokenType.VALUE);
				current.setSubType(ITokenSubType.VALUE_STRING);
				current.setOriginal(scanner.getSql().substring(
						current.getIndex(),
						next1.getIndex() + next1.getOriginal().length()));
				sb.append(current.getCustom()).append(next1.getCustom());
				current.setCustom(sb.toString());
				tokenList.removeToken(i + 1, next1TokenIndex);
				i -= 2;
				continue;
			}

			int next2TokenIndex = tokenList.getNextValidTokenIndex(i, 2);
			Token next2 = tokenList.getToken(next2TokenIndex);
			if (next2 == null)
				continue;

			int next2Type = next2.getType();
			int next2SubType = next2.getSubType();
			String next2Upper = next2.getUpper();

			if (currentType == ITokenType.NAME && ".".equals(next1.getUpper())
					&& (next2Type == ITokenType.NAME || "*".equals(next2Upper))) {
				// w . [,*]x  w.[,*]x
				current.setType(ITokenType.NAME);
				current.setSubType(ITokenSubType.DEFAULT);
				current.setOriginal(scanner.getSql().substring(
						current.getIndex(),
						next2.getIndex() + next2.getOriginal().length()));
				sb.append(current.getCustom()).append('.').append(
						next2.getCustom());
				current.setCustom(sb.toString());
				tokenList.removeToken(i + 1, next2TokenIndex);
				i--;
				continue;

			} else if ((currentType != ITokenType.NAME && currentSubType != ITokenSubType.VALUE_NUMERIC)
					&& (next1Type == ITokenType.OPERATOR && ("+"
							.equals(next1Upper) || "-".equals(next1Upper)))
					&& next2SubType == ITokenSubType.VALUE_NUMERIC) {
				// wZq Zq[+-] lx  wZq [+-]tlx
				next1.setType(ITokenType.VALUE);
				next1.setSubType(ITokenSubType.VALUE_NUMERIC);
				next1.setOriginal(scanner.getSql().substring(next1.getIndex(),
						next2.getIndex() + next2.getOriginal().length()));
				next1.setCustom(next1.getCustom() + next2.getCustom());
				tokenList.removeToken(next1TokenIndex + 1, next2TokenIndex);
				continue;
			}

			/**
			 * L[[hA
			 */
			if (!optimize)
				continue;

			if (currentType != ITokenType.KEYWORD
					|| next1Type != ITokenType.KEYWORD)
				continue;

			if (sb.length() != 0)
				sb.delete(0, sb.length()); // NA
			String str2 = null;
			String str3 = null;

			if (next2Type == ITokenType.KEYWORD) {
				int next3Index = tokenList.getNextValidTokenIndex(i, 3);
				Token next3 = tokenList.getToken(next3Index);
				if (next3 != null || next3.getType() != ITokenType.KEYWORD) {
					// SL[[h
					sb.append(currentUpper).append(' ').append(next1Upper);
					str2 = sb.toString();
					sb.append(' ').append(next2Upper);
					str3 = sb.toString();
					sb.append(' ').append(next3.getUpper());

					if (rule.isMultiKeywords(sb.toString())) {
						current
								.setOriginal(scanner.getSql().substring(
										current.getIndex(),
										next3.getIndex()
												+ next3.getOriginal().length()));
						current.setCustom(sb.toString());
						tokenList.set(i, current);
						tokenList.removeToken(i + 1, next3Index);
						continue;
					}
				}
				// RL[[h
				if (str3 == null) {
					sb.append(currentUpper).append(' ').append(next1Upper);
					str2 = sb.toString();
					sb.append(' ').append(next2Upper);
					str3 = sb.toString();
				}

				if (rule.isMultiKeywords(str3)) {
					current.setOriginal(scanner.getSql().substring(
							current.getIndex(),
							next2.getIndex() + next2.getOriginal().length()));
					current.setCustom(str3);
					tokenList.set(i, current);
					tokenList.removeToken(i + 1, next2TokenIndex);
					continue;
				}

			}
			// QL[[h
			if (str2 == null) {
				sb.append(currentUpper).append(' ').append(next1Upper);
				str2 = sb.toString();
			}

			if (rule.isMultiKeywords(str2)) {
				current.setOriginal(scanner.getSql().substring(
						current.getIndex(),
						next1.getIndex() + next1.getOriginal().length()));
				current.setCustom(str2);
				tokenList.set(i, current);
				tokenList.removeToken(i + 1, next1TokenIndex);
				continue;
			}
		}
	}

	/**
	 * ͏
	 *
	 * @param startIndex
	 * @param paren
	 * @return
	 */
	private int analyzeParenRC(int startIndex, Paren paren) {
		int parenIndex = 0;
		boolean valueOnly = true;
		int i = startIndex;

		for (; i < this.tokenList.size(); i++) {
			Token token = this.tokenList.getToken(i);
			token.setParen(paren);
			token.setParenIndex(parenIndex);

			switch (token.getType()) {
			case ITokenType.SYMBOL:
				char c = token.getCustom().charAt(0);

				switch (c) {
				case '(':
					if (token.getCustom().length() != 1)
						break;

					// eg[N
					Token parentToken = this.tokenList.getParentTokenInParen(i);
					// ʏ񐶐
					Paren newParen = new Paren(parentToken);
					token.setParen(newParen);

					// ċA
					i = analyzeParenRC(++i, newParen);
					continue;

				case ')':
					if (paren != null) {
						paren.setLength(parenIndex + 1);
						paren.setValueOnly(valueOnly);
					}
					return i;

				case ',':
					parenIndex++;
					token.setParenIndex(parenIndex); // Đݒ
					continue;
				}
				break;

			case ITokenType.KEYWORD:
				if (token.getSubType() == ITokenSubType.KEYWORD_SQL_STATEMENT
						|| token.getSubType() == ITokenSubType.KEYWORD_RESERVED_WORD)
					valueOnly = false;
				break;
			}
		}
		return i;
	}
}
